package de.simonsator.partyandfriends.clan.utilities;

import de.simonsator.partyandfriends.utilities.Language;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import de.simonsator.partyandfriends.utilities.MessagesLoader;

import java.io.File;
import java.io.IOException;

/**
 * @author Simonsator
 * @version 1.0.0 on 02.08.16.
 */
public class ClanMessagesLoader extends LanguageConfiguration {

	public ClanMessagesLoader(Language pLanguage, File pFile) throws IOException {
		super(pLanguage, pFile);
		switch (pLanguage) {
			case OWN:
				readFile();
				break;
			case GERMAN:
				loadGermanMessages();
				break;
			default:
				break;
		}
		loadEnglishMessages();
		loadSharedMessages();
		if (pLanguage == Language.OWN)
			saveFile();
		process(configuration);
	}

	private void loadSharedMessages() {
		set("General.HelpHeader", "&8&m--------------------&8[&5&lCLANS&8]&m--------------------");
		set("General.HelpEnd", "&8&m-----------------------------------------------------");
		set("Info.ClanHeader", "&8&m--------------------[&5[CLANNAME]&8&m]--------------------");
		set("Info.ClanFooter", "&8&m----------------------------------------------------");
		set("Stats.Begin", "&8&m---------------&8[&5&l[CLANNAME]&8]&m---------------");
		set("Stats.End", "&8&m-----------------------------------------------------");
		set("Chat.Color", " &7");
		set("Chat.Send", " &e[SENDER]&5:[MESSAGE]");
		set("Chat.ChatPrefix", "&8[&5ClanChat&8]&r&7");
		set("General.OnJoin.Splitter", "&7, &e");
		set("Info.LeadersCut", "&7, &5");
		set("Info.PlayersCut", "&7, &b");
	}

	private void loadEnglishMessages() {
		set("General.CommandNotFound", "&7The command was not found.");
		set("General.PlayerDoesNotExist", "&7This player has never joined the server.");
		set("General.ClanDoesNotExist", "&7This clan does not exist.");
		set("General.NoClan", "&7You are not in a clan.");
		set("General.HowToCreateAClan",
				"&7To create a clan execute the command &5/clan create [Name of the clan] [Tag of the clan]");
		set("General.ClanNotFound", "&7The clan could not be found");
		set("General.ClanFound", "&7You are already in a clan.");
		set("General.NotLeader", "&7You are not the clan leader.");
		set("General.NotInAClan", "&7This player is not in a clan.");
		set("General.NotInTheClan", "&7This player is not in the clan.");
		set("General.NotEnoughArguments", "&7You need to give further arguments");
		set("General.NotInvited", "&7You were not invited into this clan.");
		set("General.OnJoin.OpenInvitations", "&7You are invited into the following clans: &e");
		set("General.OnJoin.HowToAccept", "&7To accept an invitation, use the command &5/clan join&7." +
				" To decline an invitation, use &5/clan decline&7.");
		set("CommandUsage.Chat", "&8/&5clan chat [Message] &8- &7Write into the clan chat");
		set("CommandUsage.Create", "&8/&5clan create [ClanName] [ClanTag] &8- &7Create a clan");
		set("CommandUsage.Decline", "&8/&5clan decline [ClanName] &8- &7Decline a clan invitation");
		set("CommandUsage.Delete", "&8/&5clan delete &8- &7Deletes the clan");
		set("CommandUsage.Get", "&8/&5clan get [Player] &8- &7Outputs the clan where the given player is in");
		set("CommandUsage.Kick", "&8/&5clan kick [Player] &8- &7Kicks a player from the clan");
		set("CommandUsage.Leader", "&8/&5clan leader [Player] &8- &7Makes a new player to the leader");
		set("CommandUsage.Name", "&8/&5clan name [New name of the clan] &8- &7Sets a new name for the clan");
		set("CommandUsage.Settings", "&8/&5clan settings &8- &7Outputs the settings interface");
		set("CommandUsage.Stats", "&8/&5clan stats <Clan> &8- &7Outputs the stats of your/the given clan");
		set("CommandUsage.Tag", "&8/&5clan tag <New clan tag> &8- &7Sets the clan tag");
		set("CommandUsage.List", "&8/&5clan list <Clan> &8- &7Lists the players who are in your/the given clan.");
		set("CommandUsage.Invite", "&8/&5clan invite [Player] &8- &7Invites a player into your clan");
		set("CommandUsage.Join", "&8/&5clan join [ClanName] &8- &7Joins a clan");
		set("CommandUsage.Leave", "&8/&5clan leave &8- &7Leaves the clan");
		set("CommandUsage.Party", "&8/&5clan party &8- &7Invites all clan members into a party");
		set("Create.ClanExistsAlready", "&7The clan [CLANNAME] already exists.");
		set("General.NameTooLong", "&7This name is too long.");
		set("General.TagTooLong", "&7This tag is too long.");
		set("Create.Created", "&7The clan was created successfully.");
		set("Decline.Declined", "&7You declined the clan invitation");
		set("Delete.Deleted", "&7The clan does now no longer exist.");
		set("Get.OutPutClan", "&7The player [PLAYER] is in the clan [CLAN]");
		set("Info.ClanLeaders", "&3Leaders&7: &5");
		set("Info.Players", "&8Players&7: &b");
		set("Info.Empty", "empty");
		set("Invite.InvitedHimSelf", "&7You cannot invite yourself into the clan.");
		set("Invite.AlreadyInvited", "&7You already invited the player &e[PLAYER]&7,intotheclan.");
		set("Invite.PlayerWasInvited", "&7The player &e[PLAYER] was successfully invited into the clan.");
		set("Invite.YouWereInvited", "&7You were invited into the clan [CLANNAME].");
		set("Invite.AcceptBy", "&7Accept the clan invitation by &6/clan join [CLANNAME]&7.");
		set("Invite.Hover", "&aClick here to accept the invitation.");
		set("Invite.CanNotInviteThisPerson", "&7You cannot invite this player.");
		set("Join.AlreadyInAClan", "&7You are already in a clan.");
		set("Join.JoinedClan", "&7You joined the [CLAN].");
		set("Kick.KickHimSelf", "&7You cannot kick yourself. To leave the clan please use &5/clan leave.");
		set("Kick.KickLeader", "&7You cannot kick a leader.");
		set("Kick.PlayerKicked", "&7The player was kicked.");
		set("Leader.LeadHimSelf", "&7You cannot make yourself to a leader.");
		set("Leader.AddedLeader", "&7[NEWLEADER] is now a leader of this clan.");
		set("Leave.LeftClan", "&7You left the clan.");
		set("Party.Empty", "&7Nobody from your clan is currently online except you.");
		set("Settings.FromAll", "&aAll &7players can send you clan invitations.");
		set("Settings.FromFriends", "&6Only friends &7can send you clan invitations.");
		set("Settings.FromNobody", "&cNobody &7can send you clan invitations.");
		set("Settings.SettingWorthNotFound",
				"&7The setting worth was not found. You can either set it to &aall, &6friends &7or &cnobody&7.");
		set("Settings.SettingWorthNotFound",
				"&7The setting can be changed like this &5/clan settings <worth>&7. " +
						"You can either set the worth to &aall, &6friends &7or &cnobody&7.");
		set("Settings.FromAllNow", "&7Now you can receive clan invitations by &aeveryone&7.");
		set("Settings.FromFriendsNow", "&7Now you can receive clan invitations by &6friends&7.");
		set("Settings.FromNobodyNow", "&7Now you can receive clan invitations by &cnobody&7.");
		set("Tag.ChangedTag", "&7The tag was changed.");
	}

	private void loadGermanMessages() {
		set("General.CommandNotFound", "&7Das Kommando wurde nicht gefunden");
		set("General.PlayerDoesNotExist", "&7Dieser Spieler hat noch nie den Server betreten.");
		set("General.ClanDoesNotExist", "&7Dieser Clan existiert nicht.");
		set("General.NoClan", "&7Du bist in keinem Clan.");
		set("General.HowToCreateAClan",
				"&7Um einen Clan zu erstellen führe &5/clan &5create &5[Name &5of &5the &5clan] &5[Tag &5of &5the &5clan] &7 aus.");
		set("General.ClanNotFound", "&7Der Clan konnte nicht gefunden werden.");
		set("General.ClanFound", "&7Du bist schon in einem Clan.");
		set("General.NotLeader", "&7Du bist nicht der Clan Leader.");
		set("General.NotInAClan", "&7Dieser Spieler ist in keinem Clan.");
		set("General.NotInTheClan", "&7Dieser Spieler ist nicht in diesem Clan.");
		set("General.NotEnoughArguments", "&7Du musst weitere Informationen angeben.");
		set("General.NotInvited", "&7Du wurdest nicht in diesen Clan eingeladen.");
		set("General.OnJoin.OpenInvitations", " &7Du bist in die folgenden Clans eingeladen: &7");
		set("General.OnJoin.HowToAccept", "&7Um eine Einladung anzunehmen, nutze das Kommando &5/clan join&7." +
				" Um eine Einladung abzulehnen, nutze das Kommando &5/clan decline&7.");
		set("CommandUsage.Chat", "&8/&5clan chat [Message] &8- &7Schreibe in den Clan Chat");
		set("CommandUsage.Create", "&8/&5clan create [ClanName] [ClanTag] &8- &7Erstelle einen Clan");
		set("CommandUsage.Decline", "&8/&5clan decline [ClanName] &8- &7Lehne eine Einladung ab");
		set("CommandUsage.Delete", "&8/&5clan delete &8- &7Löscht den Clan");
		set("CommandUsage.Get", "&8/&5clan get [Player] &8- &7Gibt den Clan aus, in welchem der gegebene Spieler Mitglied ist");
		set("CommandUsage.Kick", "&8/&5clan kick [Player] &8- &7Kickt einen Spieler aus dem Clan");
		set("CommandUsage.Leader", "&8/&5clan leader [Player] &8- &7Macht einen neuen Spieler zum Leader");
		set("CommandUsage.Name", "&8/&5clan name [New name of the clan] &8- &7Benennt den Clan um");
		set("CommandUsage.Settings", "&8/&5clan settings &8- &7Zeigt die Einstellungen an");
		set("CommandUsage.Stats", "&8/&5clan stats <Clan> &8- &7Gibt die Stats deines/des gegebenen Clans aus");
		set("CommandUsage.Tag", "&8/&5clan tag <New clan tag> &8- &7Benennt den Clan Tag um");
		set("CommandUsage.List", "&8/&5clan list <Clan> &8- &7Listet die Spieler auf, die in deinem/dem gegebenen Clan sind.");
		set("CommandUsage.Invite", "&8/&5clan invite [Player] &8- &7Lädt den Spieler in den Clan ein");
		set("CommandUsage.Join", "&8/&5clan join [ClanName] &8- &7Tritt einem Clan bei");
		set("CommandUsage.Leave", "&8/&5clan leave &8- &7Verlässt den Clan");
		set("CommandUsage.Party", "&8/&5clan party &8- &7Lädt alle Mitglieder des Clans in eine Party ein");
		set("Create.ClanExistsAlready", "&7Der Clan [CLANNAME] existiert bereits.");
		set("General.NameTooLong", "&7Der Name ist zu lang.");
		set("General.TagTooLong", "&7Der Tag ist zu lang.");
		set("Create.Created", "&7Der Clan wurde erfolgreich erstellt.");
		set("Decline.Declined", "&7Du hast die Clan Einladung abgelehnt.");
		set("Delete.Deleted", "&7Der Clan existiert nun nicht mehr.");
		set("Get.OutPutClan", "&7Der Spieler [PLAYER] ist Mitglied des Clans [CLAN]");
		set("Info.ClanLeaders", "&3Leader&7: &5");
		set("Info.Players", "&8Spieler&7: &b");
		set("Info.Empty", "Keine vorhanden");
		set("Invite.InvitedHimSelf", "&7YDu kannst dich nicht selber in den Clan einladen.");
		set("Invite.AlreadyInvited", "&7Du hast den Spieler &e[PLAYER] &7bereits in den Clan eingeladen.");
		set("Invite.PlayerWasInvited", "&7Der Spieler &e[PLAYER] &7wurde erfolgreich eingeladen.");
		set("Invite.YouWereInvited", "&7Du wurdest in den Clan [CLANNAME] eingeladen.");
		set("Invite.AcceptBy", "&7Akzeptiere die Einladung mit &6/clan join [CLANNAME]&7.");
		set("Invite.Hover", "&aKlicke hier, um die Einladung zu akzeptieren.");
		set("Invite.CanNotInviteThisPerson", "&7Du kannst diesen Spieler nicht einladen.");
		set("Join.AlreadyInAClan", "&7Du bist bereits Mitglied eines Clans.");
		set("Join.JoinedClan", "&7Du bist dem Clan [CLAN] beigetreten.");
		set("Kick.KickHimSelf", "&7Du kannst dich nicht selber kicken. Um den Clan zu verlassen, nutze bitte &5/clan leave.");
		set("Kick.KickLeader", "&7Du kannst den Leader nicht kicken.");
		set("Kick.PlayerKicked", "&7Der Spieler wurde gekickt.");
		set("Leader.LeadHimSelf", "&7Du kannst dich nicht selber zum Leader machen.");
		set("Leader.AddedLeader", "&7[NEWLEADER] ist nun ein Leader des Clans.");
		set("Leave.LeftClan", "&7Du hast den Clan verlassen.");
		set("Party.Empty", "&7Niemand aus dem Clan ist momentan online außer du.");
		set("Settings.FromAll", "&aAlle &7Spieler können dir Clan Einladungen senden.");
		set("Settings.FromFriends", "&6Nur Freunde &7können dir Clan Einladungen senden.");
		set("Settings.FromNobody", "&cNiemand &7kann dir Clan Einladungen senden.");
		set("Settings.SettingWorthNotFound",
				"&7Der Einstellungswert wurde nicht gefunden. Du kannst ihn entweder zu &aall, &6friends &7oder &cnobody &7setzen.");
		set("Settings.FromAllNow", "&7Du kannst jetzt Clan Einladungen von &ajedem &7empfangen.");
		set("Settings.FromFriendsNow", "&7Du kannst jetzt Clan Einladungen von &6Freunden &7empfangen.");
		set("Settings.FromNobodyNow", "&7u kannst jetzt &ckeine &7Clan Einladungen mehr empfangen.");
		set("Tag.ChangedTag", "&Der Tag wurde geändert.");
	}

	@Override
	public void reloadConfiguration() throws IOException {
		configuration = (new MessagesLoader(LANGUAGE, FILE)).getCreatedConfiguration();
	}
}
