/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan;

import de.simonsator.partyandfriends.communication.sql.MySQLData;
import de.simonsator.partyandfriends.communication.sql.SQLCommunication;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ClanConnection
extends SQLCommunication {
    private final String TABLE_PREFIX;

    public ClanConnection(MySQLData pMySQLData) {
        super(pMySQLData.DATABASE, "jdbc:mysql://" + pMySQLData.HOST + ":" + pMySQLData.PORT, pMySQLData.USERNAME, pMySQLData.PASSWORD);
        this.TABLE_PREFIX = pMySQLData.TABLE_PREFIX;
        this.importClan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importClan() {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` (`clan_name` varchar(16) NOT NULL,\n" + "`clan_tag` varchar(4) NOT NULL,\n" + "`id` int(7) NOT NULL AUTO_INCREMENT, PRIMARY KEY (`id`))");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` (`player_id` INT(8) NOT NULL, `clan_id` INT(7) NOT NULL," + " `type` TINYINT(1) NOT NULL);");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` (`player_id` INT(8) NULL, `clan_id` INT(8) NULL);");
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClanByID(int pPlayerID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select clan_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                int n = rs.getInt("clan_id");
                this.close(rs, stmt);
                return n;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvited(int pPlayerID, int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select clan_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE player_id='" + pPlayerID + "' AND clan_id='" + pClanID + "' LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                this.close(rs, stmt);
                return bl;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getRequests(int pPlayerID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<Integer> clanRequests = new ArrayList<Integer>();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select clan_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE player_id='" + pPlayerID + "'");
            while (rs.next()) {
                clanRequests.add(rs.getInt("clan_id"));
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return clanRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequests(int pPlayerID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select clan_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                this.close(rs, stmt);
                return bl;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getRequestedPlayers(int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<Integer> requested = new ArrayList<Integer>();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE clan_id='" + pClanID + "'");
            while (rs.next()) {
                requested.add(rs.getInt("player_id"));
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createClan(int pLeader, String pClanName, String pClanTag) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement("insert into  " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` values (?, ?, ?)", 1);
            prepStmt.setString(1, pClanName);
            prepStmt.setString(2, pClanTag);
            prepStmt.setNull(3, 5);
            prepStmt.executeUpdate();
            rs = prepStmt.getGeneratedKeys();
            int clanID = 0;
            if (rs.next()) {
                clanID = rs.getInt(1);
                this.setClan(pLeader, clanID, (byte)1);
            }
            int n = clanID;
            this.close(rs, prepStmt);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, prepStmt);
        }
        return 0;
    }

    public void setClan(int pPlayer, int pClanID, byte pType) {
        this.removeClanAssignment(pPlayer, pClanID);
        if (pClanID == 0) {
            return;
        }
        this.addToClanAssignment(pPlayer, pClanID, pType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToClanAssignment(int pPlayer, int pClanID, byte pType) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("insert into " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` values (?, ?, ?)");
            prepStmt.setInt(1, pPlayer);
            prepStmt.setInt(2, pClanID);
            prepStmt.setByte(3, pType);
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClanAssignment(int pPlayer, int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE player_id = '" + pPlayer + "' AND clan_id='" + pClanID + "'");
            prepStmt.execute();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inviteIntoClan(int pClan, int pInvitedPlayerID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("insert into  " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` values (?, ?)");
            prepStmt.setInt(1, pInvitedPlayerID);
            prepStmt.setInt(2, pClan);
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClanNameByID(int pClanID) {
        block7: {
            String string;
            Connection con = this.getConnection();
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery("select clan_name from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` WHERE id='" + pClanID + "' LIMIT 1");
                if (rs.next()) {
                    String string2 = rs.getString("clan_name");
                    this.close(rs, stmt);
                    return string2;
                }
                string = null;
                this.close(rs, stmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                this.close(rs, stmt);
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClanIDByName(String pClanName) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` WHERE clan_name='" + pClanName + "' LIMIT 1");
            if (rs.next()) {
                int n = rs.getInt("id");
                this.close(rs, stmt);
                return n;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlayersFromClan(int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "'");
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlayersRequests(int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE `clan_id`='" + pClanID + "'");
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClan(int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` WHERE `id`='" + pClanID + "' LIMIT 1");
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getMembersOfClan(int pClanID) {
        ArrayList<Integer> members = new ArrayList<Integer>();
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id, type from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "'");
            while (rs.next()) {
                if (rs.getByte("type") != 0) continue;
                members.add(rs.getInt("player_id"));
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getLeadersOfClan(int pClanID) {
        ArrayList<Integer> members = new ArrayList<Integer>();
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id, type from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "' AND type='1'");
            while (rs.next()) {
                members.add(rs.getInt("player_id"));
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeader(int pPlayerID, int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select type from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next() && rs.getByte("type") == 1) {
                boolean bl = true;
                this.close(rs, stmt);
                return bl;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInClan(int pPlayerID, int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                this.close(rs, stmt);
                return bl;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getAllPlayersOfClan(int pClanID) {
        ArrayList<Integer> members = new ArrayList<Integer>();
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "'");
            while (rs.next()) {
                members.add(rs.getInt("player_id"));
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClanEmpty(int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` WHERE clan_id='" + pClanID + "' LIMIT 1");
            if (rs.next()) {
                boolean bl = false;
                this.close(rs, stmt);
                return bl;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitation(int pPlayerID, int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_request_assignment` WHERE player_id = '" + pPlayerID + "' AND clan_id='" + pClanID + "' LIMIT 1");
            prepStmt.execute();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberType(int pPlayerID, int pClanID, int pType) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clans_assignment` set type='" + pType + "' WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClanName(String pNewClanName, int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` set clan_name=? WHERE id='" + pClanID + "' LIMIT 1");
            prepStmt.setString(1, pNewClanName);
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClanTag(String pNewClanTag, int pClanID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` set clan_tag=? WHERE id='" + pClanID + "' LIMIT 1");
            prepStmt.setString(1, pNewClanTag);
            prepStmt.executeUpdate();
            this.close(prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClanTag(int pClanID) {
        Connection con = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select clan_tag from " + this.DATABASE + ".`" + this.TABLE_PREFIX + "clan` WHERE id='" + pClanID + "' LIMIT 1");
            if (rs.next()) {
                String string = rs.getString("clan_tag");
                this.close(rs, stmt);
                return string;
            }
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return null;
    }
}

