/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.api;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.api.events.ClanTagChangedEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerJointClanEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerLeftClanEvent;
import de.simonsator.partyandfriends.clan.api.events.PreClanDeleteEvent;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Event;

public abstract class Clan {
    public abstract List<PAFPlayer> getAllPlayers();

    public List<OnlinePAFPlayer> getAllOnlineClanPlayers() {
        ArrayList<OnlinePAFPlayer> list = new ArrayList<OnlinePAFPlayer>();
        for (PAFPlayer member : this.getAllPlayers()) {
            if (!member.isOnline()) continue;
            list.add((OnlinePAFPlayer)member);
        }
        return list;
    }

    public abstract String getClanName();

    public abstract void setClanName(String var1);

    public abstract String getClanTag();

    public void setClanTag(String pNewTag) {
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new ClanTagChangedEvent(this));
    }

    public abstract boolean isLeader(PAFPlayer var1);

    public abstract List<PAFPlayer> getLeaders();

    public abstract List<PAFPlayer> getMembers();

    public void sendMessage(TextComponent pTextComponent) {
        for (PAFPlayer player : this.getAllPlayers()) {
            player.sendMessage(pTextComponent);
        }
    }

    public void acceptRequest(OnlinePAFPlayer pPlayer) {
        this.removeRequest((PAFPlayer)pPlayer);
        this.addToClan((PAFPlayer)pPlayer);
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new PlayerJointClanEvent(this, pPlayer));
    }

    protected abstract void addToClan(PAFPlayer var1);

    public void deleteClan() {
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new PreClanDeleteEvent(this));
    }

    public abstract boolean contains(PAFPlayer var1);

    public void removeFromClan(PAFPlayer pPlayer) {
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new PlayerLeftClanEvent(this, pPlayer));
    }

    public abstract void addLeader(PAFPlayer var1);

    public abstract List<PAFPlayer> getInvitedPlayers();

    public abstract boolean isInvited(PAFPlayer var1);

    public abstract void invite(PAFPlayer var1);

    public abstract void removeLeader(PAFPlayer var1);

    public abstract void removeRequest(PAFPlayer var1);
}

