/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.api.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.commands.ClanCommands;
import de.simonsator.partyandfriends.utilities.SubCommand;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.protocol.packet.Chat;

public abstract class ClanSubCommand
extends SubCommand {
    public static final int LEADERS = 2;
    public static final int NO_CLAN = -1;
    public static final int HAS_CLAN = 1;
    private final String PERMISSION;
    private final String CREATE_NAME = (String)ClansMain.getInstance().getConfig().getStringList("Commands.Create.Names").get(0);

    public ClanSubCommand(String[] pCommands, int pPriority, String pHelp) {
        super(pCommands, pPriority, pHelp, ClansMain.getInstance().getClanPrefix());
        this.PERMISSION = "";
    }

    public ClanSubCommand(String[] pCommands, String pPermission, int pPriority, String pHelp) {
        super(pCommands, pPriority, pHelp, ClansMain.getInstance().getClanPrefix());
        this.PERMISSION = pPermission;
    }

    protected void sendError(OnlinePAFPlayer pPlayer, String pIdentifier) {
        this.sendError(pPlayer, new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString(pIdentifier)));
    }

    protected boolean enoughArguments(OnlinePAFPlayer pPlayer, String[] args, int n) {
        if (args.length < n) {
            this.sendError(pPlayer, "General.NotEnoughArguments");
            return false;
        }
        return true;
    }

    protected boolean enoughArguments(OnlinePAFPlayer pPlayer, String[] args) {
        return this.enoughArguments(pPlayer, args, 2);
    }

    protected Clan getClan(OnlinePAFPlayer pPlayer, String[] args) {
        Clan clan = ClansManager.getInstance().getClan(args[1]);
        if (clan == null) {
            this.sendError(pPlayer, "General.ClanNotFound");
            return null;
        }
        return clan;
    }

    protected Clan getClan(OnlinePAFPlayer pPlayer) {
        Clan clan = ClansManager.getInstance().getClan((PAFPlayer)pPlayer);
        if (clan == null) {
            pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString("General.NoClan")));
            pPlayer.sendPacket(new Chat("{\"text\":\"" + ClansMain.getInstance().getMessages().getString("General.HowToCreateAClan") + "\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/" + ClanCommands.getInstance().getName() + " " + this.CREATE_NAME + " " + "\"}}"));
            return null;
        }
        return clan;
    }

    protected boolean isLeader(OnlinePAFPlayer pPlayer, Clan pClan) {
        if (!pClan.isLeader((PAFPlayer)pPlayer)) {
            this.sendError(pPlayer, "General.NotLeader");
            return false;
        }
        return true;
    }

    protected PAFPlayer getPlayer(OnlinePAFPlayer pPlayer, String[] args) {
        PAFPlayer player = PAFPlayerManager.getInstance().getPlayer(args[1]);
        if (!player.doesExist()) {
            this.sendError(pPlayer, "General.PlayerDoesNotExist");
            return null;
        }
        return player;
    }

    public final void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (this.hasPermission(pPlayer)) {
            this.execute(pPlayer, args);
        } else {
            pPlayer.sendMessage(this.PREFIX + ClansMain.getInstance().getMessages().getString("General.NoPermission"));
        }
    }

    protected abstract void execute(OnlinePAFPlayer var1, String[] var2);

    public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
        return this.hasPermission(pPlayer);
    }

    public boolean hasPermission(OnlinePAFPlayer pPlayer) {
        return this.PERMISSION.equals("") || pPlayer.hasPermission(this.PERMISSION);
    }

    protected void sendError(OnlinePAFPlayer pPlayer, TextComponent pMessage) {
        pPlayer.sendMessage(pMessage);
        this.printOutHelp(pPlayer, ClanCommands.getInstance().getName());
    }
}

