/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.clans.clan;

import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.pafplayers.manager.PAFPlayerManagerMySQL;
import de.simonsator.partyandfriends.pafplayers.mysql.PAFPlayerMySQL;
import java.util.ArrayList;
import java.util.List;

public class MySQLClan
extends Clan {
    private final int CLAN_ID;

    public MySQLClan(int pClanID) {
        this.CLAN_ID = pClanID;
    }

    @Override
    public List<PAFPlayer> getAllPlayers() {
        return this.toPAFPlayerList(ClansMain.getInstance().getConnection().getAllPlayersOfClan(this.CLAN_ID));
    }

    @Override
    public String getClanName() {
        return ClansMain.getInstance().getConnection().getClanNameByID(this.CLAN_ID);
    }

    @Override
    public void setClanName(String pNewName) {
        ClansMain.getInstance().getConnection().setClanName(pNewName, this.CLAN_ID);
    }

    @Override
    public String getClanTag() {
        return ClansMain.getInstance().getConnection().getClanTag(this.CLAN_ID);
    }

    @Override
    public void setClanTag(String pNewTag) {
        super.setClanTag(pNewTag);
        ClansMain.getInstance().getConnection().setClanTag(pNewTag, this.CLAN_ID);
    }

    @Override
    public boolean isLeader(PAFPlayer pPlayer) {
        return ClansMain.getInstance().getConnection().isLeader(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID);
    }

    @Override
    public List<PAFPlayer> getLeaders() {
        return this.toPAFPlayerList(ClansMain.getInstance().getConnection().getLeadersOfClan(this.CLAN_ID));
    }

    @Override
    public List<PAFPlayer> getMembers() {
        return this.toPAFPlayerList(ClansMain.getInstance().getConnection().getMembersOfClan(this.CLAN_ID));
    }

    @Override
    protected void addToClan(PAFPlayer pPlayer) {
        ClansMain.getInstance().getConnection().setClan(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID, (byte)0);
    }

    @Override
    public void deleteClan() {
        super.deleteClan();
        ClansMain.getInstance().getConnection().removeAllPlayersFromClan(this.CLAN_ID);
        ClansMain.getInstance().getConnection().removeAllPlayersRequests(this.CLAN_ID);
        ClansMain.getInstance().getConnection().removeClan(this.CLAN_ID);
    }

    @Override
    public boolean contains(PAFPlayer pPlayer) {
        return ClansMain.getInstance().getConnection().isInClan(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID);
    }

    @Override
    public void removeFromClan(PAFPlayer pPlayer) {
        List<PAFPlayer> members = this.getAllPlayers();
        this.removeLeader(pPlayer);
        ClansMain.getInstance().getConnection().removeClanAssignment(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID);
        if (ClansMain.getInstance().getConnection().isClanEmpty(this.CLAN_ID)) {
            this.deleteClan();
        } else if (this.getLeaders().isEmpty()) {
            this.addLeader(members.get(0));
        }
        super.removeFromClan(pPlayer);
    }

    @Override
    public void addLeader(PAFPlayer pPlayer) {
        ClansMain.getInstance().getConnection().setMemberType(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID, 1);
    }

    @Override
    public List<PAFPlayer> getInvitedPlayers() {
        return this.toPAFPlayerList(ClansMain.getInstance().getConnection().getRequestedPlayers(this.CLAN_ID));
    }

    @Override
    public boolean isInvited(PAFPlayer pPlayer) {
        return ClansMain.getInstance().getConnection().isInvited(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID);
    }

    @Override
    public void invite(PAFPlayer pPlayer) {
        ClansMain.getInstance().getConnection().inviteIntoClan(this.getClanID(), ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    @Override
    public void removeLeader(PAFPlayer pPlayer) {
        ClansMain.getInstance().getConnection().setMemberType(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID, 0);
    }

    @Override
    public void removeRequest(PAFPlayer pPlayer) {
        ClansMain.getInstance().getConnection().removeInvitation(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.CLAN_ID);
    }

    private List<PAFPlayer> toPAFPlayerList(List<Integer> list) {
        ArrayList<PAFPlayer> list2 = new ArrayList<PAFPlayer>();
        for (int id : list) {
            list2.add(((PAFPlayerManagerMySQL)PAFPlayerManager.getInstance()).getPlayer(id));
        }
        return list2;
    }

    private int getClanID() {
        return this.CLAN_ID;
    }
}

