/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanLeaderCommand;
import de.simonsator.partyandfriends.clan.commands.ClanCommands;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.protocol.packet.Chat;

public class Invite
extends ClanLeaderCommand {
    private final String JOIN_COMMAND_NAME;

    public Invite(String[] pCommands, String pPermission, int pPriority, String pHelp, String pJoinCommandName) {
        super(pCommands, pPermission, pPriority, pHelp);
        this.JOIN_COMMAND_NAME = "/" + ClanCommands.getInstance().getName() + " " + pJoinCommandName + " ";
    }

    @Override
    protected void execute(OnlinePAFPlayer pPlayer, String[] args) {
        if (!this.enoughArguments(pPlayer, args)) {
            return;
        }
        if (pPlayer.getName().equalsIgnoreCase(args[1])) {
            this.sendError(pPlayer, "Invite.InvitedHimSelf");
            return;
        }
        Clan clan = this.getClan(pPlayer);
        if (clan == null) {
            return;
        }
        if (!this.isLeader(pPlayer, clan)) {
            return;
        }
        PAFPlayer invited = this.getPlayer(pPlayer, args);
        if (invited == null) {
            return;
        }
        if (clan.isInvited(invited)) {
            this.sendError(pPlayer, new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString("Invite.AlreadyInvited").replace("[PLAYER]", args[1])));
            return;
        }
        switch (pPlayer.getSettingsWorth(10)) {
            case 1: {
                if (pPlayer.isAFriendOf(invited)) break;
                this.sendCanNotInviteError(pPlayer);
                break;
            }
            case 2: {
                this.sendCanNotInviteError(pPlayer);
                break;
            }
        }
        if (ClansManager.getInstance().getClan(invited) != null) {
            this.sendCanNotInviteError(pPlayer);
            return;
        }
        clan.invite(invited);
        pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString("Invite.PlayerWasInvited").replace("[PLAYER]", invited.getDisplayName())));
        String clanName = clan.getClanName();
        invited.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString("Invite.YouWereInvited").replace("[CLANNAME]", clanName)));
        invited.sendPacket(new Chat("{\"text\":\"" + ClansMain.getInstance().getMessages().getString("Invite.AcceptBy").replace("[CLANNAME]", clanName) + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + this.JOIN_COMMAND_NAME + clanName + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ClansMain.getInstance().getMessages().getString("Invite.Hover") + "\"}]}}}"));
    }

    private void sendCanNotInviteError(OnlinePAFPlayer pPlayer) {
        pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().getString("Invite.CanNotInviteThisPerson")));
    }
}

