/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClanStat;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import de.simonsator.partyandfriends.clan.commands.ClanCommands;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Plugin;

public class Stats
extends ClanSubCommand {
    private final List<ClanStatInfo> CLAN_STATS = new ArrayList<ClanStatInfo>();

    public Stats(String[] pCommands, String pPermission, int pPriority, String pHelp) {
        super(pCommands, pPermission, pPriority, pHelp);
    }

    @Override
    protected void execute(OnlinePAFPlayer pPlayer, String[] args) {
        if (this.CLAN_STATS.isEmpty()) {
            pPlayer.sendMessage(ClanCommands.getInstance().getPrefix() + "You need to install a plugin that supports clan stats \u00a7cto \u00a7csee \u00a7cthe stats of a clan in a minigame." + " If you don't want \u00a7cto \u00a7cinstall \u00a7cany, disable this command in the config.");
            return;
        }
        Clan clan = args.length == 1 ? this.getClan(pPlayer) : this.getClan(pPlayer, args);
        if (clan == null) {
            return;
        }
        pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Stats.Begin").replace("[CLANNAME]", clan.getClanName())));
        for (ClanStatInfo clanStatInfo : this.CLAN_STATS) {
            pPlayer.sendMessage(ClansMain.getInstance().getMessages().getString("Stats.BeginOfAStat").replace("[STATS_NAME]", clanStatInfo.CLAN_STATS.getName()));
            clanStatInfo.CLAN_STATS.stats(pPlayer, clan);
            pPlayer.sendMessage(ClansMain.getInstance().getMessages().getString("Stats.EndOfAStat"));
        }
        pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Stats.End")));
    }

    public void registerClanStats(ClanStat pStats, Plugin pPlugin) {
        this.CLAN_STATS.add(new ClanStatInfo(pStats, pPlugin));
    }

    public void unregisterAll(Plugin pPlugin) {
        if (this.CLAN_STATS.remove(new ClanStatInfo(null, pPlugin))) {
            this.unregisterAll(pPlugin);
        }
    }

    private class ClanStatInfo {
        private final ClanStat CLAN_STATS;
        private final Plugin PLUGIN;

        private ClanStatInfo(ClanStat pClanStat, Plugin pPlugin) {
            this.CLAN_STATS = pClanStat;
            this.PLUGIN = pPlugin;
        }

        public boolean equals(ClanStatInfo pObject) {
            return pObject.PLUGIN.equals(this.PLUGIN);
        }
    }
}

