/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.gui.menuextensions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.simonsator.datastructures.ItemPackage;
import de.simonsator.partyandfriendsgui.api.events.creation.menu.SettingsMenuCreationEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class SettingsMenuExtension
implements Listener {
    private final ItemStack TOP_ITEM;
    private final ItemStack ALL_ITEM;
    private final ItemStack FRIENDS_ITEM;
    private final ItemStack NONE_ITEM;

    public SettingsMenuExtension(ItemStack TOP_ITEM, ItemStack pAllItem, ItemStack pFriendItem, ItemStack pNoneItem) {
        this.TOP_ITEM = TOP_ITEM;
        this.ALL_ITEM = pAllItem;
        this.FRIENDS_ITEM = pFriendItem;
        this.NONE_ITEM = pNoneItem;
    }

    @EventHandler
    public void extendSettingsMenu(SettingsMenuCreationEvent pEvent) {
        for (JsonElement element : pEvent.getData().get("settings").getAsJsonArray()) {
            JsonObject setting = element.getAsJsonObject();
            if (setting.get("id").getAsInt() != 10) continue;
            pEvent.addItemPackage(this.createSettingPackage(setting.get("worth").getAsInt()));
            break;
        }
    }

    private ItemPackage createSettingPackage(int pWorth) {
        ItemStack itemToAdd;
        switch (pWorth) {
            case 0: {
                itemToAdd = this.ALL_ITEM;
                break;
            }
            case 1: {
                itemToAdd = this.FRIENDS_ITEM;
                break;
            }
            case 2: {
                itemToAdd = this.NONE_ITEM;
                break;
            }
            default: {
                return null;
            }
        }
        return new ItemPackage(this.TOP_ITEM, itemToAdd);
    }
}

