/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.gui.tasks.communicationtasks;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.simonsator.partyandfriendsgui.Main;
import de.simonsator.partyandfriendsgui.communication.tasks.CommunicationTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class OpenClanRequestMenu
extends CommunicationTask {
    private final String INVENTORY_NAME;
    private final String COLOR_OF_THE_REQUESTER;
    private final boolean USE_LEADER_HEAD;
    private final Material ALT_MATERIAL;

    public OpenClanRequestMenu(String pInvName, String pColorOfTheRequester, boolean pUseLeaderHead, String pAltItemName) {
        super("OpenClanRequestMenu");
        this.INVENTORY_NAME = pInvName;
        this.COLOR_OF_THE_REQUESTER = pColorOfTheRequester;
        this.USE_LEADER_HEAD = pUseLeaderHead;
        this.ALT_MATERIAL = Material.valueOf((String)pAltItemName);
    }

    public void executeTask(Player pPlayer, JsonObject pJObj) {
        JsonArray friendRequests = pJObj.get("clanRequests").getAsJsonArray();
        int toSet = ((friendRequests.size() + 2) / 9 + 1) * 9;
        if (toSet >= 27) {
            toSet = 45;
        }
        Inventory inv = Bukkit.createInventory(null, (int)toSet, (String)this.INVENTORY_NAME);
        for (int i = 0; i < friendRequests.size() && i != toSet; ++i) {
            ItemStack item;
            JsonObject jobj = friendRequests.get(i).getAsJsonObject();
            String playerName = jobj.get("name").getAsString();
            String itemName = this.COLOR_OF_THE_REQUESTER + playerName;
            if (this.USE_LEADER_HEAD) {
                item = new ItemStack(Material.SKULL_ITEM, 1, 3);
                item.setItemMeta(this.setDisplayName(item, itemName));
                SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
                skullMeta.setOwner(jobj.get("leader").toString());
                item.setItemMeta((ItemMeta)skullMeta);
            } else {
                item = new ItemStack(this.ALT_MATERIAL);
                item.setItemMeta(this.setDisplayName(item, itemName));
            }
            inv.addItem(new ItemStack[]{item});
        }
        inv.setItem(toSet - 1, Main.getInstance().blockOutput(-1, -1));
        pPlayer.openInventory(inv);
    }

    private ItemMeta setDisplayName(ItemStack pStack, String pName) {
        ItemMeta meta = pStack.getItemMeta();
        meta.setDisplayName(pName);
        return meta;
    }
}

