/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.clan.utilities;

import de.simonsator.partyandfriends.utilities.Language;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import de.simonsator.partyandfriends.utilities.MessagesLoader;
import java.io.File;
import java.io.IOException;

public class ClanMessagesLoader
extends LanguageConfiguration {
    public ClanMessagesLoader(Language pLanguage, File pFile) throws IOException {
        super(pLanguage, pFile);
        switch (pLanguage) {
            case OWN: {
                this.readFile();
                break;
            }
            case GERMAN: {
                this.loadGermanMessages();
                break;
            }
        }
        this.loadEnglishMessages();
        this.loadSharedMessages();
        if (pLanguage == Language.OWN) {
            this.saveFile();
        }
        this.process(this.configuration);
    }

    private void loadSharedMessages() {
        this.set("General.HelpHeader", "&8&m--------------------&8[&5&lCLANS&8]&m--------------------");
        this.set("General.HelpEnd", "&8&m-----------------------------------------------------");
        this.set("Info.ClanHeader", "&8&m--------------------[&5[CLANNAME]&8&m]--------------------");
        this.set("Info.ClanFooter", "&8&m----------------------------------------------------");
        this.set("Stats.Begin", "&8&m---------------&8[&5&l[CLANNAME]&8]&m---------------");
        this.set("Stats.BeginOfAStat", "&8&m------------&8[&5&l[STATS_NAME]&8]&m------------");
        this.set("Stats.EndOfAStat", "&8&m-----------------------------------------------------");
        this.set("Stats.End", "&8&m-----------------------------------------------------");
        this.set("Chat.Color", " &7");
        this.set("Chat.Send", " &e[SENDER]&5:[MESSAGE]");
        this.set("Chat.ChatPrefix", "&8[&5ClanChat&8]&r&7");
        this.set("General.OnJoin.Splitter", "&7, &e");
        this.set("Info.LeadersCut", "&7, &5");
        this.set("Info.PlayersCut", "&7, &b");
    }

    private void loadEnglishMessages() {
        this.set("General.CommandNotFound", "&7The command was not found.");
        this.set("General.PlayerDoesNotExist", "&7This player has never joined the server.");
        this.set("General.ClanDoesNotExist", "&7This clan does not exist.");
        this.set("General.NoClan", "&7You are not in a clan.");
        this.set("General.HowToCreateAClan", "&7To create a clan execute the command &5/clan create [Name of the clan] [Tag of the clan]");
        this.set("General.ClanNotFound", "&7The clan could not be found");
        this.set("General.ClanFound", "&7You are already in a clan.");
        this.set("General.NotLeader", "&7You are not the clan leader.");
        this.set("General.NotInAClan", "&7This player is not in a clan.");
        this.set("General.NotInTheClan", "&7This player is not in the clan.");
        this.set("General.NotEnoughArguments", "&7You need to give further arguments");
        this.set("General.NotInvited", "&7You were not invited into this clan.");
        this.set("General.NoPermission", "&cYou do not have the permission to execute this command.");
        this.set("General.OnJoin.OpenInvitations", "&7You are invited into the following clans: &e");
        this.set("General.OnJoin.HowToAccept", "&7To accept an invitation, use the command &5/clan join&7. To decline an invitation, use &5/clan decline&7.");
        this.set("CommandUsage.Chat", "&8/&5clan chat [Message] &8- &7Write into the clan chat");
        this.set("CommandUsage.Create", "&8/&5clan create [ClanName] [ClanTag] &8- &7Create a clan");
        this.set("CommandUsage.Decline", "&8/&5clan decline [ClanName] &8- &7Decline a clan invitation");
        this.set("CommandUsage.Delete", "&8/&5clan delete &8- &7Deletes the clan");
        this.set("CommandUsage.Get", "&8/&5clan get [Player] &8- &7Outputs the clan where the given player is in");
        this.set("CommandUsage.Kick", "&8/&5clan kick [Player] &8- &7Kicks a player from the clan");
        this.set("CommandUsage.Leader", "&8/&5clan leader [Player] &8- &7Makes a new player to the leader");
        this.set("CommandUsage.Name", "&8/&5clan name [New name of the clan] &8- &7Sets a new name for the clan");
        this.set("CommandUsage.Settings", "&8/&5clan settings &8- &7Outputs the settings interface");
        this.set("CommandUsage.Stats", "&8/&5clan stats <Clan> &8- &7Outputs the stats of your/the given clan");
        this.set("CommandUsage.Tag", "&8/&5clan tag <New clan tag> &8- &7Sets the clan tag");
        this.set("CommandUsage.List", "&8/&5clan list <Clan> &8- &7Lists the players who are in your/the given clan.");
        this.set("CommandUsage.Invite", "&8/&5clan invite [Player] &8- &7Invites a player into your clan");
        this.set("CommandUsage.Join", "&8/&5clan join [ClanName] &8- &7Joins a clan");
        this.set("CommandUsage.Leave", "&8/&5clan leave &8- &7Leaves the clan");
        this.set("CommandUsage.Party", "&8/&5clan party &8- &7Invites all clan members into a party");
        this.set("Create.ClanExistsAlready", "&7The clan [CLANNAME] already exists.");
        this.set("General.NameTooLong", "&7This name is too long.");
        this.set("General.TagTooLong", "&7This tag is too long.");
        this.set("Create.Created", "&7The clan was created successfully.");
        this.set("Decline.Declined", "&7You declined the clan invitation");
        this.set("Delete.Deleted", "&7The clan does now no longer exist.");
        this.set("Get.OutPutClan", "&7The player [PLAYER] is in the clan [CLAN]");
        this.set("Info.ClanLeaders", "&3Leaders&7: &5");
        this.set("Info.Players", "&8Players&7: &b");
        this.set("Info.Empty", "Empty");
        this.set("Invite.InvitedHimSelf", "&7You cannot invite yourself into the clan.");
        this.set("Invite.AlreadyInvited", "&7You already invited the player &e[PLAYER]&7 into the clan.");
        this.set("Invite.PlayerWasInvited", "&7The player &e[PLAYER] &7was successfully invited into the clan.");
        this.set("Invite.YouWereInvited", "&7You were invited into the clan [CLANNAME].");
        this.set("Invite.AcceptBy", "&7Accept the clan invitation by &6/clan join [CLANNAME]&7.");
        this.set("Invite.Hover", "&aClick here to accept the invitation.");
        this.set("Invite.CanNotInviteThisPerson", "&7You cannot invite this player.");
        this.set("Join.AlreadyInAClan", "&7You are already in a clan.");
        this.set("Join.JoinedClan", "&7You joined the [CLAN].");
        this.set("Kick.KickHimSelf", "&7You cannot kick yourself. To leave the clan please use &5/clan leave.");
        this.set("Kick.KickLeader", "&7You cannot kick a leader.");
        this.set("Kick.PlayerKicked", "&7The player was kicked.");
        this.set("Leader.LeadHimSelf", "&7You cannot make yourself to a leader.");
        this.set("Leader.AddedLeader", "&7[NEWLEADER] is now a leader of this clan.");
        this.set("Leave.LeftClan", "&7You left the clan.");
        this.set("Party.Empty", "&7Nobody from your clan is currently online except you.");
        this.set("Settings.FromAll", "&aAll &7players can send you clan invitations.");
        this.set("Settings.FromFriends", "&6Only friends &7can send you clan invitations.");
        this.set("Settings.FromNobody", "&cNobody &7can send you clan invitations.");
        this.set("Settings.SettingWorthNotFound", "&7The setting worth was not found. You can either set it to &aall, &6friends &7or &cnobody&7.");
        this.set("Settings.HowToChange", "&7The setting can be changed like this &5/clan settings <worth>&7. You can either set the worth to &aall, &6friends &7or &cnobody&7.");
        this.set("Settings.FromAllNow", "&7Now you can receive clan invitations by &aeveryone&7.");
        this.set("Settings.FromFriendsNow", "&7Now you can receive clan invitations by &6friends&7.");
        this.set("Settings.FromNobodyNow", "&7Now you can receive clan invitations by &cnobody&7.");
        this.set("Tag.ChangedTag", "&7The tag was changed.");
    }

    private void loadGermanMessages() {
        this.set("General.CommandNotFound", "&7Das Kommando wurde nicht gefunden");
        this.set("General.PlayerDoesNotExist", "&7Dieser Spieler hat noch nie den Server betreten.");
        this.set("General.ClanDoesNotExist", "&7Dieser Clan existiert nicht.");
        this.set("General.NoClan", "&7Du bist in keinem Clan.");
        this.set("General.HowToCreateAClan", "&7Um einen Clan zu erstellen f\u00fchre &5/clan &5create &5[Name &5of &5the &5clan] &5[Tag &5of &5the &5clan] &7 aus.");
        this.set("General.ClanNotFound", "&7Der Clan konnte nicht gefunden werden.");
        this.set("General.ClanFound", "&7Du bist schon in einem Clan.");
        this.set("General.NotLeader", "&7Du bist nicht der Clan Leader.");
        this.set("General.NotInAClan", "&7Dieser Spieler ist in keinem Clan.");
        this.set("General.NotInTheClan", "&7Dieser Spieler ist nicht in diesem Clan.");
        this.set("General.NotEnoughArguments", "&7Du musst weitere Informationen angeben.");
        this.set("General.NotInvited", "&7Du wurdest nicht in diesen Clan eingeladen.");
        this.set("General.NoPermission", "&cDu hast nicht die Permission um das Kommando auszuf\u00fchren.");
        this.set("General.OnJoin.OpenInvitations", " &7Du bist in die folgenden Clans eingeladen: &7");
        this.set("General.OnJoin.HowToAccept", "&7Um eine Einladung anzunehmen, nutze das Kommando &5/clan join&7. Um eine Einladung abzulehnen, nutze das Kommando &5/clan decline&7.");
        this.set("CommandUsage.Chat", "&8/&5clan chat [Message] &8- &7Schreibe in den Clan Chat");
        this.set("CommandUsage.Create", "&8/&5clan create [ClanName] [ClanTag] &8- &7Erstelle einen Clan");
        this.set("CommandUsage.Decline", "&8/&5clan decline [ClanName] &8- &7Lehne eine Einladung ab");
        this.set("CommandUsage.Delete", "&8/&5clan delete &8- &7L\u00f6scht den Clan");
        this.set("CommandUsage.Get", "&8/&5clan get [Player] &8- &7Gibt den Clan aus, in welchem der gegebene Spieler Mitglied ist");
        this.set("CommandUsage.Kick", "&8/&5clan kick [Player] &8- &7Kickt einen Spieler aus dem Clan");
        this.set("CommandUsage.Leader", "&8/&5clan leader [Player] &8- &7Macht einen neuen Spieler zum Leader");
        this.set("CommandUsage.Name", "&8/&5clan name [New name of the clan] &8- &7Benennt den Clan um");
        this.set("CommandUsage.Settings", "&8/&5clan settings &8- &7Zeigt die Einstellungen an");
        this.set("CommandUsage.Stats", "&8/&5clan stats <Clan> &8- &7Gibt die Stats deines/des gegebenen Clans aus");
        this.set("CommandUsage.Tag", "&8/&5clan tag <New clan tag> &8- &7Benennt den Clan Tag um");
        this.set("CommandUsage.List", "&8/&5clan list <Clan> &8- &7Listet die Spieler auf, die in deinem/dem gegebenen Clan sind.");
        this.set("CommandUsage.Invite", "&8/&5clan invite [Player] &8- &7L\u00e4dt den Spieler in den Clan ein");
        this.set("CommandUsage.Join", "&8/&5clan join [ClanName] &8- &7Tritt einem Clan bei");
        this.set("CommandUsage.Leave", "&8/&5clan leave &8- &7Verl\u00e4sst den Clan");
        this.set("CommandUsage.Party", "&8/&5clan party &8- &7L\u00e4dt alle Mitglieder des Clans in eine Party ein");
        this.set("Create.ClanExistsAlready", "&7Der Clan [CLANNAME] existiert bereits.");
        this.set("General.NameTooLong", "&7Der Name ist zu lang.");
        this.set("General.TagTooLong", "&7Der Tag ist zu lang.");
        this.set("Create.Created", "&7Der Clan wurde erfolgreich erstellt.");
        this.set("Decline.Declined", "&7Du hast die Clan Einladung abgelehnt.");
        this.set("Delete.Deleted", "&7Der Clan existiert nun nicht mehr.");
        this.set("Get.OutPutClan", "&7Der Spieler [PLAYER] ist Mitglied des Clans [CLAN]");
        this.set("Info.ClanLeaders", "&3Leader&7: &5");
        this.set("Info.Players", "&8Spieler&7: &b");
        this.set("Info.Empty", "Keine vorhanden");
        this.set("Invite.InvitedHimSelf", "&7YDu kannst dich nicht selber in den Clan einladen.");
        this.set("Invite.AlreadyInvited", "&7Du hast den Spieler &e[PLAYER] &7bereits in den Clan eingeladen.");
        this.set("Invite.PlayerWasInvited", "&7Der Spieler &e[PLAYER] &7wurde erfolgreich eingeladen.");
        this.set("Invite.YouWereInvited", "&7Du wurdest in den Clan [CLANNAME] eingeladen.");
        this.set("Invite.AcceptBy", "&7Akzeptiere die Einladung mit &6/clan join [CLANNAME]&7.");
        this.set("Invite.Hover", "&aKlicke hier, um die Einladung zu akzeptieren.");
        this.set("Invite.CanNotInviteThisPerson", "&7Du kannst diesen Spieler nicht einladen.");
        this.set("Join.AlreadyInAClan", "&7Du bist bereits Mitglied eines Clans.");
        this.set("Join.JoinedClan", "&7Du bist dem Clan [CLAN] beigetreten.");
        this.set("Kick.KickHimSelf", "&7Du kannst dich nicht selber kicken. Um den Clan zu verlassen, nutze bitte &5/clan leave.");
        this.set("Kick.KickLeader", "&7Du kannst den Leader nicht kicken.");
        this.set("Kick.PlayerKicked", "&7Der Spieler wurde gekickt.");
        this.set("Leader.LeadHimSelf", "&7Du kannst dich nicht selber zum Leader machen.");
        this.set("Leader.AddedLeader", "&7[NEWLEADER] ist nun ein Leader des Clans.");
        this.set("Leave.LeftClan", "&7Du hast den Clan verlassen.");
        this.set("Party.Empty", "&7Niemand aus dem Clan ist momentan online au\u00dfer du.");
        this.set("Settings.FromAll", "&aAlle &7Spieler k\u00f6nnen dir Clan Einladungen senden.");
        this.set("Settings.FromFriends", "&6Nur Freunde &7k\u00f6nnen dir Clan Einladungen senden.");
        this.set("Settings.FromNobody", "&cNiemand &7kann dir Clan Einladungen senden.");
        this.set("Settings.SettingWorthNotFound", "&7Der Einstellungswert wurde nicht gefunden. Du kannst ihn entweder zu &aall, &6friends &7oder &cnobody &7setzen.");
        this.set("Settings.FromAllNow", "&7Du kannst jetzt Clan Einladungen von &ajedem &7empfangen.");
        this.set("Settings.FromFriendsNow", "&7Du kannst jetzt Clan Einladungen von &6Freunden &7empfangen.");
        this.set("Settings.FromNobodyNow", "&7u kannst jetzt &ckeine &7Clan Einladungen mehr empfangen.");
        this.set("Tag.ChangedTag", "&7Der Tag wurde ge\u00e4ndert.");
    }

    public void reloadConfiguration() throws IOException {
        this.configuration = new MessagesLoader(this.LANGUAGE, this.FILE).getCreatedConfiguration();
    }
}

