/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.api.party;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class PlayerParty {
    public abstract boolean isLeader(PAFPlayer var1);

    public boolean isLeader(OnlinePAFPlayer player) {
        return this.isLeader((PAFPlayer)player);
    }

    public abstract boolean isBanned(PAFPlayer var1);

    public abstract void setBanned(PAFPlayer var1, boolean var2);

    public abstract boolean isPrivate();

    public abstract void setPrivateState(boolean var1);

    public boolean isInParty(OnlinePAFPlayer pPlayer) {
        return this.isAMember(pPlayer) || pPlayer.getUniqueId().equals(this.getLeader().getUniqueId());
    }

    protected abstract boolean isAMember(OnlinePAFPlayer var1);

    protected abstract List<UUID> getInvited();

    public boolean isNobodyInvited() {
        return this.getInvited().isEmpty();
    }

    public abstract OnlinePAFPlayer getLeader();

    public abstract void setLeader(OnlinePAFPlayer var1);

    public List<OnlinePAFPlayer> getAllPlayers() {
        List<OnlinePAFPlayer> allPlayers = this.getPlayers();
        OnlinePAFPlayer leader = this.getLeader();
        if (leader != null) {
            allPlayers.add(leader);
        }
        return allPlayers;
    }

    protected abstract void removePlayerSilent(PAFPlayer var1);

    public abstract List<OnlinePAFPlayer> getPlayers();

    public abstract boolean addPlayer(OnlinePAFPlayer var1);

    public void leaveParty(OnlinePAFPlayer pPlayer) {
        this.leaveParty((PAFPlayer)pPlayer);
    }

    public abstract void leaveParty(PAFPlayer var1);

    public abstract void kickPlayer(OnlinePAFPlayer var1);

    public abstract void invite(OnlinePAFPlayer var1);

    public abstract void removeFromInvited(PAFPlayer var1);

    public void removeFromInvited(OnlinePAFPlayer pPlayer) {
        this.removeFromInvited((PAFPlayer)pPlayer);
    }

    protected abstract void addToInvited(OnlinePAFPlayer var1);

    public boolean isPartyEmpty() {
        return this.getPlayers().isEmpty() && this.isNobodyInvited();
    }

    public abstract int getInviteListSize();

    public boolean isInvited(OnlinePAFPlayer pPlayer) {
        return !this.isPrivate() || this.getInvited().contains(pPlayer.getUniqueId());
    }

    public void sendMessage(TextComponent pText) {
        for (OnlinePAFPlayer player : this.getAllPlayers()) {
            player.sendMessage(pText);
        }
    }

    public void sendMessage(String pText) {
        for (OnlinePAFPlayer player : this.getAllPlayers()) {
            player.sendMessage(pText);
        }
    }

    protected abstract boolean needsNewLeader(PAFPlayer var1);

    protected abstract void findNewLeader();
}

