/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons;

import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.PAFFloodGateExtension;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGFriendListMenu;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGOfflineFriendDetailViewMenu;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGOnlineFriendDetailViewMenu;
import de.simonsator.partyandfriends.velocity.main.Main;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.PlayerListElement;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FriendButton
extends PAFFloodgateButtonHandler {
    private final String BUTTON_DISPLAY_NAME;
    private final PlayerListElement FRIEND;
    private final ConfigurationCreator config = PAFFloodGateExtension.getInstance().getConfig();
    private final FGFriendListMenu FRIEND_LIST_MENU_INSTANCE;

    public FriendButton(PlayerListElement pFriend, FGFriendListMenu pFriendListMenuInstance) {
        String tempButtonName;
        this.FRIEND_LIST_MENU_INSTANCE = pFriendListMenuInstance;
        this.FRIEND = pFriend;
        if (this.FRIEND.isOnline()) {
            tempButtonName = this.config.getString("FriendListMenu.FriendList.FriendButton.Online.DisplayName").replace("%server_name%", this.FRIEND.getServerDisplayName());
        } else {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(Main.getInstance().getGeneralConfig().getString("General.Time.Format"), Locale.forLanguageTag(Main.getInstance().getGeneralConfig().getString("General.Time.LanguageTag")));
            tempButtonName = this.config.getString("FriendListMenu.FriendList.FriendButton.Offline.DisplayName").replace("%last_online%", DATE_FORMAT.format(this.FRIEND.getLastOnline()));
        }
        this.BUTTON_DISPLAY_NAME = tempButtonName.replace("%player_name%", this.FRIEND.getDisplayName());
    }

    @Override
    public void handleButtonPress(OnlinePAFPlayer pPlayer) {
        FGOfflineFriendDetailViewMenu detailViewMenu = this.FRIEND.isOnline() ? new FGOnlineFriendDetailViewMenu(this.config, this.FRIEND, this.FRIEND_LIST_MENU_INSTANCE) : new FGOfflineFriendDetailViewMenu(this.config, this.FRIEND, this.FRIEND_LIST_MENU_INSTANCE);
        detailViewMenu.openMenu(pPlayer);
    }

    @Override
    public String getButtonDisplayName(OnlinePAFPlayer pPlayer) {
        return this.BUTTON_DISPLAY_NAME;
    }

    @Override
    public String getImageURL(OnlinePAFPlayer pPlayer) {
        String pathPart = "Offline";
        if (this.FRIEND.isOnline()) {
            pathPart = "Online";
        }
        if (this.config.getBoolean("FriendMenu.FriendList.FriendButton." + pathPart + ".Image.Use")) {
            return this.config.getString("FriendMenu.FriendList.FriendButton." + pathPart + ".Image.URL");
        }
        return null;
    }

    @Override
    public String getImageType(OnlinePAFPlayer pPlayer) {
        String pathPart = "Offline";
        if (this.FRIEND.isOnline()) {
            pathPart = "Online";
        }
        return this.config.getString("FriendMenu.FriendList.FriendButton." + pathPart + ".Image.Type");
    }
}

