/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons;

import de.simonsator.partyandfriends.velocity.api.TopCommand;
import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.PAFFloodGateExtension;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.SubCommand;

public class FriendInteractionButton
extends PAFFloodgateButtonHandler {
    private final SubCommand SUB_COMMAND;
    private final String FRIEND_NAME;
    private final String CONFIG_PATH;
    private final String PLAYER_DISPLAY_NAME;
    private final String BUTTON_IMAGE_TYPE;

    public FriendInteractionButton(TopCommand<?> topCommand, Class<? extends SubCommand> subCommand, String pConfigPath, String pFriendName, String pPlayerDisplayName) {
        this.SUB_COMMAND = topCommand.getSubCommand(subCommand);
        this.CONFIG_PATH = pConfigPath;
        this.FRIEND_NAME = pFriendName;
        this.PLAYER_DISPLAY_NAME = pPlayerDisplayName;
        this.BUTTON_IMAGE_TYPE = PAFFloodGateExtension.getInstance().getConfig().getString(pConfigPath + ".Image.Type");
    }

    @Override
    public void handleButtonPress(OnlinePAFPlayer pPlayer) {
        this.SUB_COMMAND.onCommand(pPlayer, new String[]{this.FRIEND_NAME, this.FRIEND_NAME});
    }

    @Override
    public String getButtonDisplayName(OnlinePAFPlayer pPlayer) {
        ConfigurationCreator config = PAFFloodGateExtension.getInstance().getConfig();
        return config.getString(this.CONFIG_PATH + ".DisplayName").replace("%player_name%", this.PLAYER_DISPLAY_NAME);
    }

    @Override
    public String getImageURL(OnlinePAFPlayer pPlayer) {
        ConfigurationCreator config = PAFFloodGateExtension.getInstance().getConfig();
        if (config.getBoolean(this.CONFIG_PATH + ".Image.Use")) {
            return config.getString(this.CONFIG_PATH + ".Image.URL");
        }
        return null;
    }

    @Override
    public String getImageType(OnlinePAFPlayer pPlayer) {
        return this.BUTTON_IMAGE_TYPE;
    }
}

