/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.listeners;

import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.JustOneButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGFriendMenu;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGPartyMenu;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGSettingsMenu;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import java.util.HashMap;
import java.util.Map;
import org.geysermc.floodgate.api.FloodgateApi;

public abstract class GenericMenuCreationListener {
    private final Map<String, PAFFloodgateMenuHandler> floodgateMenus = new HashMap<String, PAFFloodgateMenuHandler>();

    protected GenericMenuCreationListener(ConfigurationCreator config) {
        FGFriendMenu friendMenu = new FGFriendMenu(config);
        FGPartyMenu partyMenu = new FGPartyMenu(config);
        FGSettingsMenu settingsMenu = new FGSettingsMenu(config);
        if (config.getBoolean("FriendMenu.SwitchToPartyMenu.Use")) {
            friendMenu.addMenuPart(new JustOneButtonMenuPart(config, "FriendMenu.SwitchToPartyMenu", partyMenu));
        }
        if (config.getBoolean("FriendMenu.SwitchToSettingsMenu.Use")) {
            friendMenu.addMenuPart(new JustOneButtonMenuPart(config, "FriendMenu.SwitchToSettingsMenu", settingsMenu));
        }
        if (config.getBoolean("PartyMenu.SwitchToFriendMenu.Use")) {
            partyMenu.addMenuPart(new JustOneButtonMenuPart(config, "PartyMenu.SwitchToFriendMenu", friendMenu));
        }
        if (config.getBoolean("PartyMenu.SwitchToSettingsMenu.Use")) {
            partyMenu.addMenuPart(new JustOneButtonMenuPart(config, "PartyMenu.SwitchToSettingsMenu", settingsMenu));
        }
        if (config.getBoolean("SettingsMenu.SwitchToFriendMenu.Use")) {
            settingsMenu.addMenuPart(new JustOneButtonMenuPart(config, "SettingsMenu.SwitchToFriendMenu", friendMenu));
        }
        if (config.getBoolean("SettingsMenu.SwitchToPartyMenu.Use")) {
            settingsMenu.addMenuPart(new JustOneButtonMenuPart(config, "SettingsMenu.SwitchToPartyMenu", partyMenu));
        }
        this.floodgateMenus.put("FRIEND_MENU", friendMenu);
        this.floodgateMenus.put("PARTY_MENU", partyMenu);
        this.floodgateMenus.put("SETTINGS_MENU", settingsMenu);
    }

    protected boolean floodgateMenuExists(OnlinePAFPlayer pPlayer, String pMenuName) {
        PAFFloodgateMenuHandler menu = this.floodgateMenus.get(pMenuName);
        if (menu != null && FloodgateApi.getInstance().getPlayer(pPlayer.getUniqueId()) != null) {
            menu.openMenu(pPlayer);
            return true;
        }
        return false;
    }

    public void addFloodGateMenu(String pMenuIdentifier, PAFFloodgateMenuHandler pMenu) {
        this.floodgateMenus.put(pMenuIdentifier, pMenu);
    }
}

