/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.BackButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.JustOneButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.SimpleFormMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons.FriendButton;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGChangeFriendSortingMenu;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.PlayerListElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geysermc.cumulus.SimpleForm;

public class FGFriendListMenu
extends SimpleFormMenuHandler<AdditionalInfo> {
    public FGFriendListMenu(ConfigurationCreator config, PAFFloodgateMenuHandler pLastMenu) {
        super(config);
        if (config.getBoolean("FriendListMenu.BackButton.Use")) {
            this.MENU_PARTS.add(new BackButtonMenuPart(config.getInt("FriendListMenu.BackButton.Priority"), pLastMenu));
        }
        if (config.getBoolean("FriendListMenu.ChangeSorting.Use")) {
            this.MENU_PARTS.add(new JustOneButtonMenuPart(config, "FriendListMenu.ChangeSorting", new FGChangeFriendSortingMenu(config, this)));
        }
        this.MENU_PARTS.add(new FriendList(config.getInt("FriendListMenu.FriendList.Priority")));
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, AdditionalInfo additionalInfo, SimpleForm.Builder form) {
        form.title(this.config.getString("FriendListMenu.Title").replace("%friend_count%", Integer.toString(additionalInfo.FRIEND_COUNT)));
        if (additionalInfo.FRIEND_COUNT == 0) {
            form.content(this.config.getString("FriendListMenu.YouCurrentlyHaveNoFriendsText"));
        }
    }

    @Override
    protected AdditionalInfo createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        int sorting = pPlayer.getSettingsWorth(102);
        List playerListElements = PlayerListElement.getFriendsAsPlayerListElement((OnlinePAFPlayer)pPlayer, (int)sorting);
        Collections.sort(playerListElements);
        return new AdditionalInfo(sorting, playerListElements, this);
    }

    private static class FriendList
    extends SimpleFormMenuPart<AdditionalInfo> {
        protected FriendList(int priority) {
            super(priority);
        }

        @Override
        public int addMenuItems(Map<Integer, PAFFloodgateButtonHandler> buttons, int currentButtonId, SimpleForm.Builder form, OnlinePAFPlayer pPlayer, AdditionalInfo pInfo) {
            for (PlayerListElement friend : pInfo.PLAYER_LIST_ELEMENTS) {
                currentButtonId = this.addButton(buttons, currentButtonId, form, new FriendButton(friend, pInfo.FRIEND_LIST_MENU_INSTANCE), pPlayer);
            }
            return currentButtonId;
        }
    }

    protected static class AdditionalInfo {
        public final int SORTING;
        public final List<PlayerListElement> PLAYER_LIST_ELEMENTS;
        public final int FRIEND_COUNT;
        public final FGFriendListMenu FRIEND_LIST_MENU_INSTANCE;

        private AdditionalInfo(int sorting, List<PlayerListElement> pPlayerListElements, FGFriendListMenu pInstance) {
            this.SORTING = sorting;
            this.PLAYER_LIST_ELEMENTS = pPlayerListElements;
            this.FRIEND_COUNT = pPlayerListElements.size();
            this.FRIEND_LIST_MENU_INSTANCE = pInstance;
        }
    }
}

