/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.MenuOpeningButton;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.BackButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.SimpleFormMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGFriendRequestListDetailView;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geysermc.cumulus.SimpleForm;

public class FGFriendRequestList
extends SimpleFormMenuHandler<AdditionalInfo> {
    public FGFriendRequestList(ConfigurationCreator config, PAFFloodgateMenuHandler pLastMenu) {
        super(config);
        if (config.getBoolean("FriendRequestListMenu.BackButton.Use")) {
            this.MENU_PARTS.add(new BackButtonMenuPart(config.getInt("FriendRequestListMenu.BackButton.Priority"), pLastMenu));
        }
        this.MENU_PARTS.add(new FriendRequestList(config.getInt("FriendRequestListMenu.RequestButton.Priority")));
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, AdditionalInfo additionalInfo, SimpleForm.Builder form) {
        form.title(this.config.getString("FriendRequestListMenu.Title").replace("%friend_request_count%", Integer.toString(additionalInfo.FRIEND_REQUESTS.size())));
        if (additionalInfo.FRIEND_REQUESTS.size() == 0) {
            form.content(this.config.getString("FriendListMenu.YouCurrentlyHaveNoFriendsText"));
        }
    }

    @Override
    protected AdditionalInfo createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        List friendRequests = pPlayer.getRequests();
        return new AdditionalInfo(friendRequests, this.config, this);
    }

    private static class FriendRequestList
    extends SimpleFormMenuPart<AdditionalInfo> {
        protected FriendRequestList(int priority) {
            super(priority);
        }

        @Override
        public int addMenuItems(Map<Integer, PAFFloodgateButtonHandler> buttons, int currentButtonId, SimpleForm.Builder form, OnlinePAFPlayer pPlayer, AdditionalInfo pInfo) {
            for (PAFPlayer friendRequest : pInfo.FRIEND_REQUESTS) {
                currentButtonId = this.addButton(buttons, currentButtonId, form, new MenuOpeningButton(pInfo.CONFIG, "FriendRequestListMenu.RequestButton", new FGFriendRequestListDetailView(pInfo.CONFIG, friendRequest, pInfo.FRIEND_REQUEST_LIST_MENU_INSTANCE), pInfo.CONFIG.getString("FriendRequestListMenu.RequestButton.DisplayName").replace("%player_name%", friendRequest.getDisplayName())), pPlayer);
            }
            return currentButtonId;
        }
    }

    protected static class AdditionalInfo {
        public final List<PAFPlayer> FRIEND_REQUESTS;
        private final FGFriendRequestList FRIEND_REQUEST_LIST_MENU_INSTANCE;
        private final ConfigurationCreator CONFIG;

        private AdditionalInfo(List<PAFPlayer> pFriendRequests, ConfigurationCreator pConfig, FGFriendRequestList pInstance) {
            this.FRIEND_REQUESTS = pFriendRequests;
            this.FRIEND_REQUEST_LIST_MENU_INSTANCE = pInstance;
            this.CONFIG = pConfig;
        }
    }
}

