/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.api.party.PlayerParty;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.MenuOpeningButton;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.BackButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.SimpleFormMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGPartyMemberDetailViewMenu;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import java.util.Collections;
import java.util.Map;
import org.geysermc.cumulus.SimpleForm;

public class FGPartyListMenu
extends SimpleFormMenuHandler<AdditionalInfo> {
    public FGPartyListMenu(ConfigurationCreator config, PAFFloodgateMenuHandler pLastMenu) {
        super(config);
        if (config.getBoolean("PartyMemberListMenu.BackButton.Use")) {
            this.MENU_PARTS.add(new BackButtonMenuPart(config.getInt("PartyMemberListMenu.BackButton.Priority"), pLastMenu));
        }
        if (config.getBoolean("PartyMemberListMenu.PartyLeaderButton.Use")) {
            this.MENU_PARTS.add(new PartyLeaderMenuPart(config.getInt("PartyMemberListMenu.PartyLeaderButton.Priority")));
        }
        if (config.getBoolean("PartyMemberListMenu.PartyMemberButton.Use")) {
            this.MENU_PARTS.add(new PartyMemberMenuPart(config.getInt("PartyMemberListMenu.PartyMemberButton.Priority")));
        }
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, AdditionalInfo additionalInfo, SimpleForm.Builder form) {
        if (additionalInfo.PARTY == null) {
            form.title(this.config.getString("PartyMemberListMenu.Title").replace("%party_player_count%", "0"));
            form.content(this.config.getString("PartyMemberListMenu.Content.NoParty"));
        } else {
            form.title(this.config.getString("PartyMemberListMenu.Title").replace("%party_player_count%", Integer.toString(additionalInfo.PARTY.getAllPlayers().size())));
        }
    }

    @Override
    protected AdditionalInfo createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        return new AdditionalInfo(pPlayer.getParty(), this.config, this);
    }

    private static class PartyLeaderMenuPart
    extends SimpleFormMenuPart<AdditionalInfo> {
        protected PartyLeaderMenuPart(int priority) {
            super(priority);
        }

        @Override
        public int addMenuItems(Map<Integer, PAFFloodgateButtonHandler> buttons, int currentButtonId, SimpleForm.Builder form, OnlinePAFPlayer pPlayer, AdditionalInfo pInfo) {
            if (pInfo.PARTY == null) {
                return currentButtonId;
            }
            SimpleFormMenuHandler menuToOpen = pInfo.PARTY_LIST_MENU_INSTANCE;
            OnlinePAFPlayer partyLeader = pInfo.PARTY.getLeader();
            if (!partyLeader.equals((Object)pPlayer)) {
                menuToOpen = new FGPartyMemberDetailViewMenu(pInfo.CONFIG, pPlayer, pInfo.PARTY.getLeader(), true, pInfo.PARTY_LIST_MENU_INSTANCE);
            }
            currentButtonId = this.addButton(buttons, currentButtonId, form, new MenuOpeningButton(pInfo.CONFIG, "PartyMemberListMenu.PartyLeaderButton", menuToOpen, pInfo.CONFIG.getString("PartyMemberListMenu.PartyLeaderButton.DisplayName").replace("%player_name%", partyLeader.getDisplayName())), pPlayer);
            return currentButtonId;
        }
    }

    private static class PartyMemberMenuPart
    extends SimpleFormMenuPart<AdditionalInfo> {
        protected PartyMemberMenuPart(int priority) {
            super(priority);
        }

        @Override
        public int addMenuItems(Map<Integer, PAFFloodgateButtonHandler> buttons, int currentButtonId, SimpleForm.Builder form, OnlinePAFPlayer pPlayer, AdditionalInfo pInfo) {
            if (pInfo.PARTY == null) {
                return currentButtonId;
            }
            for (OnlinePAFPlayer partyMembers : pInfo.PARTY.getPlayers()) {
                SimpleFormMenuHandler menuToOpen = pInfo.PARTY_LIST_MENU_INSTANCE;
                if (!pPlayer.equals((Object)partyMembers)) {
                    menuToOpen = new FGPartyMemberDetailViewMenu(pInfo.CONFIG, pPlayer, partyMembers, false, pInfo.PARTY_LIST_MENU_INSTANCE);
                }
                currentButtonId = this.addButton(buttons, currentButtonId, form, new MenuOpeningButton(pInfo.CONFIG, "PartyMemberListMenu.PartyMemberButton", menuToOpen, pInfo.CONFIG.getString("PartyMemberListMenu.PartyMemberButton.DisplayName").replace("%player_name%", partyMembers.getDisplayName())), pPlayer);
            }
            return currentButtonId;
        }
    }

    protected static class AdditionalInfo {
        public final PlayerParty PARTY;
        public final FGPartyListMenu PARTY_LIST_MENU_INSTANCE;
        private final ConfigurationCreator CONFIG;

        private AdditionalInfo(PlayerParty pParty, ConfigurationCreator pConfig, FGPartyListMenu pInstance) {
            this.PARTY = pParty;
            this.PARTY_LIST_MENU_INSTANCE = pInstance;
            this.CONFIG = pConfig;
        }
    }
}

