/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.TopCommand;
import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.api.party.PlayerParty;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.BackButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.JustOneButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons.FriendInteractionButton;
import de.simonsator.partyandfriends.velocity.friends.commands.Friends;
import de.simonsator.partyandfriends.velocity.friends.subcommands.Add;
import de.simonsator.partyandfriends.velocity.party.command.PartyCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.Kick;
import de.simonsator.partyandfriends.velocity.party.subcommand.Leader;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.SubCommand;
import java.util.Collections;
import org.geysermc.cumulus.SimpleForm;

public class FGPartyMemberDetailViewMenu
extends SimpleFormMenuHandler<PartyDetailViewInfo> {
    public final OnlinePAFPlayer PARTY_MEMBER;
    public final OnlinePAFPlayer MENU_VIEWER;
    public final boolean IS_CURRENT_PARTY_MEMBER_LEADER;

    public FGPartyMemberDetailViewMenu(ConfigurationCreator config, OnlinePAFPlayer pMenuViewer, OnlinePAFPlayer pPartyMember, boolean pIsCurrentPartyMemberLeader, PAFFloodgateMenuHandler pLastMenu) {
        super(config);
        this.PARTY_MEMBER = pPartyMember;
        this.MENU_VIEWER = pMenuViewer;
        this.IS_CURRENT_PARTY_MEMBER_LEADER = pIsCurrentPartyMemberLeader;
        if (config.getBoolean("PartyMemberDetailView.BackButton.Use")) {
            this.MENU_PARTS.add(new BackButtonMenuPart(config.getInt("PartyMemberDetailView.BackButton.Priority"), pLastMenu));
        }
        if (config.getBoolean("PartyMemberDetailView.AddFriend.Use")) {
            this.MENU_PARTS.add(new JustOneButtonMenuPart(config.getInt("PartyMemberDetailView.AddFriend.Priority"), new FriendInteractionButton((TopCommand<?>)Friends.getInstance(), (Class<? extends SubCommand>)Add.class, "PartyMemberDetailView.AddFriend", pPartyMember.getName(), pPartyMember.getDisplayName())));
        }
        if (config.getBoolean("PartyMemberDetailView.MakeLeader.Use")) {
            this.MENU_PARTS.add(new OnlyPartyLeaderMenuPart(config, "PartyMemberDetailView.MakeLeader", new FriendInteractionButton((TopCommand<?>)PartyCommand.getInstance(), (Class<? extends SubCommand>)Leader.class, "PartyMemberDetailView.MakeLeader", pPartyMember.getName(), pPartyMember.getDisplayName())));
        }
        if (config.getBoolean("PartyMemberDetailView.KickPlayer.Use")) {
            this.MENU_PARTS.add(new OnlyPartyLeaderMenuPart(config, "PartyMemberDetailView.KickPlayer", new FriendInteractionButton((TopCommand<?>)PartyCommand.getInstance(), (Class<? extends SubCommand>)Kick.class, "PartyMemberDetailView.KickPlayer", pPartyMember.getName(), pPartyMember.getDisplayName())));
        }
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, PartyDetailViewInfo additionalInfo, SimpleForm.Builder form) {
        String configPath = "Member";
        if (this.IS_CURRENT_PARTY_MEMBER_LEADER) {
            configPath = "Leader";
        }
        form.title(this.config.getString("PartyMemberDetailView." + configPath + ".Title").replace("%player_name%", this.PARTY_MEMBER.getDisplayName()));
        form.content(this.config.getString("PartyMemberDetailView." + configPath + ".Content").replace("%player_name%", this.PARTY_MEMBER.getDisplayName()));
    }

    @Override
    protected PartyDetailViewInfo createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        PlayerParty party = pPlayer.getParty();
        if (party == null) {
            return new PartyDetailViewInfo(false, this.PARTY_MEMBER);
        }
        return new PartyDetailViewInfo(party.isLeader(pPlayer), this.PARTY_MEMBER);
    }

    private static class OnlyPartyLeaderMenuPart
    extends JustOneButtonMenuPart<PartyDetailViewInfo> {
        public OnlyPartyLeaderMenuPart(ConfigurationCreator config, String pConfigPath, FriendInteractionButton pMenu) {
            super(config.getInt(pConfigPath + ".Priority"), pMenu);
        }

        @Override
        protected boolean shouldAdd(OnlinePAFPlayer pPlayer, PartyDetailViewInfo pAdditionalInfo) {
            return pAdditionalInfo.IS_VIEWER_PARTY_LEADER;
        }
    }

    public static class PartyDetailViewInfo {
        public final boolean IS_VIEWER_PARTY_LEADER;
        public final OnlinePAFPlayer CURRENT_PARTY_MEMBER;

        public PartyDetailViewInfo(boolean pIsViewerPartyLeader, OnlinePAFPlayer pCurrentPartyMember) {
            this.IS_VIEWER_PARTY_LEADER = pIsViewerPartyLeader;
            this.CURRENT_PARTY_MEMBER = pCurrentPartyMember;
        }
    }
}

