/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.TopCommand;
import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.api.party.PlayerParty;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.JustOneButtonMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFGCommandInputMenu;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.PAFFloodgateMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons.FriendInteractionButton;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus.FGPartyListMenu;
import de.simonsator.partyandfriends.velocity.party.command.PartyCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.Invite;
import de.simonsator.partyandfriends.velocity.party.subcommand.Join;
import de.simonsator.partyandfriends.velocity.party.subcommand.Leave;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.SubCommand;
import java.util.Collections;
import org.geysermc.cumulus.SimpleForm;

public class FGPartyMenu
extends SimpleFormMenuHandler<PartyInfo> {
    public FGPartyMenu(ConfigurationCreator config) {
        super(config);
        if (config.getBoolean("PartyMenu.Invite.Use")) {
            this.MENU_PARTS.add(new PartyLeaderOrNoPartyMenuPart(config, "PartyMenu.Invite", new PAFFGCommandInputMenu(config, "InvitePartyMenu", (TopCommand<?>)PartyCommand.getInstance(), (Class<? extends SubCommand>)Invite.class)));
        }
        if (config.getBoolean("PartyMenu.AcceptInvite.Use")) {
            this.MENU_PARTS.add(new NoPartyMenuPart(config, "PartyMenu.AcceptInvite", new PAFFGCommandInputMenu(config, "AcceptPartyMenu", (TopCommand<?>)PartyCommand.getInstance(), (Class<? extends SubCommand>)Join.class)));
        }
        if (config.getBoolean("PartyMenu.ListPartyMembers.Use")) {
            this.MENU_PARTS.add(new HasPartyMenuParty(config, "PartyMenu.ListPartyMembers", new FGPartyListMenu(config, this)));
        }
        if (config.getBoolean("PartyMenu.LeaveParty.Use")) {
            this.MENU_PARTS.add(new HasPartyMenuParty(config.getInt("PartyMenu.LeaveParty.Priority"), new FriendInteractionButton((TopCommand<?>)PartyCommand.getInstance(), (Class<? extends SubCommand>)Leave.class, "PartyMenu.LeaveParty", "leave", "")));
        }
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected PartyInfo createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        PlayerParty party = pPlayer.getParty();
        if (party == null) {
            return new PartyInfo(null, false);
        }
        return new PartyInfo(party, party.isLeader(pPlayer));
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, PartyInfo additionalInfo, SimpleForm.Builder form) {
        form.title(this.config.getString("PartyMenu.Title"));
    }

    private static class PartyLeaderOrNoPartyMenuPart
    extends JustOneButtonMenuPart<PartyInfo> {
        public PartyLeaderOrNoPartyMenuPart(ConfigurationCreator config, String pConfigPath, PAFFloodgateMenuHandler pMenu) {
            super(config, pConfigPath, pMenu);
        }

        @Override
        protected boolean shouldAdd(OnlinePAFPlayer pPlayer, PartyInfo pAdditionalInfo) {
            return pAdditionalInfo.PARTY == null || pAdditionalInfo.VIEWER_IS_LEADER;
        }
    }

    private static class NoPartyMenuPart
    extends JustOneButtonMenuPart<PartyInfo> {
        public NoPartyMenuPart(ConfigurationCreator config, String pConfigPath, PAFFloodgateMenuHandler pMenu) {
            super(config, pConfigPath, pMenu);
        }

        @Override
        protected boolean shouldAdd(OnlinePAFPlayer pPlayer, PartyInfo pAdditionalInfo) {
            return pAdditionalInfo.PARTY == null;
        }
    }

    private static class HasPartyMenuParty
    extends JustOneButtonMenuPart<PartyInfo> {
        public HasPartyMenuParty(ConfigurationCreator config, String pConfigPath, PAFFloodgateMenuHandler pMenu) {
            super(config, pConfigPath, pMenu);
        }

        public HasPartyMenuParty(int priority, PAFFloodgateButtonHandler pButton) {
            super(priority, pButton);
        }

        @Override
        protected boolean shouldAdd(OnlinePAFPlayer pPlayer, PartyInfo pAdditionalInfo) {
            return pAdditionalInfo.PARTY != null;
        }
    }

    public static class PartyInfo {
        private final PlayerParty PARTY;
        private final boolean VIEWER_IS_LEADER;

        private PartyInfo(PlayerParty party, boolean pViewrIsPartyLeader) {
            this.PARTY = party;
            this.VIEWER_IS_LEADER = pViewrIsPartyLeader;
        }
    }
}

