/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.extensions.floodgategui.menus;

import de.simonsator.partyandfriends.velocity.api.Setting;
import de.simonsator.partyandfriends.velocity.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.input.buttons.PAFFloodgateButtonHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menuparts.simpleform.SimpleFormMenuPart;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.api.menus.SimpleFormMenuHandler;
import de.simonsator.partyandfriends.velocity.extensions.floodgategui.buttons.SettingsButton;
import de.simonsator.partyandfriends.velocity.friends.settings.FriendRequestSetting;
import de.simonsator.partyandfriends.velocity.friends.settings.JumpSetting;
import de.simonsator.partyandfriends.velocity.friends.settings.OfflineSetting;
import de.simonsator.partyandfriends.velocity.friends.settings.OnlineStatusNotificationSetting;
import de.simonsator.partyandfriends.velocity.friends.settings.PMSetting;
import de.simonsator.partyandfriends.velocity.party.settings.InviteSetting;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import java.util.Collections;
import java.util.Map;
import org.geysermc.cumulus.SimpleForm;

public class FGSettingsMenu
extends SimpleFormMenuHandler<Object> {
    private final FGSettingsMenu INSTANCE = this;
    private final boolean REOPEN_SETTINGS_MENU;

    public FGSettingsMenu(ConfigurationCreator config) {
        super(config);
        this.REOPEN_SETTINGS_MENU = config.getBoolean("SettingsMenu.ReopenSettingMenu");
        if (config.getBoolean("SettingsMenu.DoNotReceiveFriendRequests.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.DoNotReceiveFriendRequests", FriendRequestSetting.class, 0));
        }
        if (config.getBoolean("SettingsMenu.PlayerCanJumpToYou.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.PlayerCanJumpToYou", JumpSetting.class, 4));
        }
        if (config.getBoolean("SettingsMenu.ShowOnlineStatus.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.ShowOnlineStatus", OfflineSetting.class, 3));
        }
        if (config.getBoolean("SettingsMenu.NotifyOnlineStatusChange.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.NotifyOnlineStatusChange", OnlineStatusNotificationSetting.class, 101));
        }
        if (config.getBoolean("SettingsMenu.ReceivePrivateMessages.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.ReceivePrivateMessages", PMSetting.class, 2));
        }
        if (config.getBoolean("SettingsMenu.ReceivePartyInvites.Use")) {
            this.MENU_PARTS.add(new SettingMenuPart(config, "SettingsMenu.ReceivePartyInvites", InviteSetting.class, 1));
        }
        Collections.sort(this.MENU_PARTS);
    }

    @Override
    protected void setTitle(OnlinePAFPlayer pPlayer, Object additionalInfo, SimpleForm.Builder form) {
        form.title(this.config.getString("SettingsMenu.Title"));
    }

    @Override
    protected Object createAdditionalInfo(OnlinePAFPlayer pPlayer) {
        return null;
    }

    private class SettingMenuPart
    extends SimpleFormMenuPart<Object> {
        private final SettingsButton CURRENTLY_ENABLED_BUTTON;
        private final SettingsButton CURRENTLY_DISABLED_BUTTON;
        private final int SETTINGS_ID;

        public SettingMenuPart(ConfigurationCreator config, String pConfigPath, Class<? extends Setting> pSetting, int pSettingsId) {
            super(config.getInt(pConfigPath + ".Priority"));
            this.CURRENTLY_DISABLED_BUTTON = new SettingsButton(config, pConfigPath + ".OptionDisabled", pSetting, FGSettingsMenu.this.REOPEN_SETTINGS_MENU, FGSettingsMenu.this.INSTANCE);
            this.CURRENTLY_ENABLED_BUTTON = new SettingsButton(config, pConfigPath + ".OptionEnabled", pSetting, FGSettingsMenu.this.REOPEN_SETTINGS_MENU, FGSettingsMenu.this.INSTANCE);
            this.SETTINGS_ID = pSettingsId;
        }

        @Override
        public int addMenuItems(Map<Integer, PAFFloodgateButtonHandler> buttons, int currentButtonId, SimpleForm.Builder form, OnlinePAFPlayer pPlayer, Object pAdditionalInfo) {
            if (pPlayer.getSettingsWorth(this.SETTINGS_ID) == 0) {
                this.addButton(buttons, currentButtonId++, form, this.CURRENTLY_ENABLED_BUTTON, pPlayer);
            } else {
                this.addButton(buttons, currentButtonId++, form, this.CURRENTLY_DISABLED_BUTTON, pPlayer);
            }
            return currentButtonId;
        }
    }
}

