/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.partytoggle;

import de.simonsator.partyandfriends.velocity.api.PAFExtension;
import de.simonsator.partyandfriends.velocity.api.PAFPluginBase;
import de.simonsator.partyandfriends.velocity.api.adapter.ServerSoftware;
import de.simonsator.partyandfriends.velocity.main.Main;
import de.simonsator.partyandfriends.velocity.party.command.PartyCommand;
import de.simonsator.partyandfriends.velocity.partytoggle.PTConfig;
import de.simonsator.partyandfriends.velocity.partytoggle.PartyToggle;
import de.simonsator.partyandfriends.velocity.partytoggle.chatmanager.UniversalChatManager;
import de.simonsator.partyandfriends.velocity.partytoggle.chatmanager.VelocityChatManagerFactory;
import de.simonsator.partyandfriends.velocity.utilities.SubCommand;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class PTMain
extends PAFExtension {
    public PTMain(Path folder) {
        super(folder);
    }

    public void onEnable() {
        try {
            UniversalChatManager chatManager;
            PTConfig config = new PTConfig(new File(this.getConfigFolder(), "config.yml"), this);
            ServerSoftware serverSoftware = this.getAdapter().getServerSoftware();
            switch (serverSoftware) {
                case VELOCITY: {
                    chatManager = VelocityChatManagerFactory.createChatManager();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported server software " + serverSoftware);
                }
            }
            this.getAdapter().registerListener((Object)chatManager, (PAFPluginBase)Main.getInstance());
            PartyCommand.getInstance().addCommand((SubCommand)new PartyToggle(config.getStringList("Names"), config.getInt("Priority"), config.getString("Messages.Help"), chatManager, config));
            this.registerAsExtension();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "Party-Toggle";
    }
}

