/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.spigot.communication.sql;

import de.simonsator.partyandfriends.spigot.error.ErrorReporter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public abstract class SQLCommunication {
    protected final String DATABASE;
    private final String URL;
    private Connection connection;
    private final String USER_NAME;
    private final String PASSWORD;
    private final boolean USE_SSL;

    public SQLCommunication(String pDatabase, String pURL, String pUserName, String pPassword) {
        this.DATABASE = pDatabase;
        this.URL = pURL + "/" + this.DATABASE;
        this.USER_NAME = pUserName;
        this.PASSWORD = pPassword;
        this.USE_SSL = false;
        this.connection = this.createConnection();
    }

    public SQLCommunication(String pDatabase, String pURL, String pUserName, String pPassword, boolean pUseSSL) {
        this.DATABASE = pDatabase;
        this.URL = pURL + "/" + this.DATABASE;
        this.USER_NAME = pUserName;
        this.PASSWORD = pPassword;
        this.USE_SSL = pUseSSL;
        this.connection = this.createConnection();
    }

    protected void close(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void close(ResultSet rs, Statement stmt, PreparedStatement prepStmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (prepStmt != null) {
                prepStmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected Connection getConnection() {
        try {
            if (this.connection != null && this.connection.isValid(6)) {
                return this.connection;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = this.createConnection();
        return this.connection;
    }

    protected void close(PreparedStatement pPrepStmt) {
        try {
            if (pPrepStmt != null) {
                pPrepStmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Connection createConnection() {
        try {
            this.closeConnection();
            Class.forName("com.mysql.jdbc.Driver");
            Properties properties = new Properties();
            properties.setProperty("user", this.USER_NAME);
            properties.setProperty("password", this.PASSWORD);
            properties.setProperty("useSSL", this.USE_SSL + "");
            properties.setProperty("allowPublicKeyRetrieval", !this.USE_SSL + "");
            properties.setProperty("database", this.DATABASE);
            properties.setProperty("createDatabaseIfNotExist", "true");
            return DriverManager.getConnection(this.URL, properties);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            new ErrorReporter("\u00a7cFriends API for Spigot for Party And Friends for Proxy was either not able to connect to the MySQL database or to login into the MySQL database. Please correct your MySQL data in the config.yml. If you need further help contact Simonsator via Discord (@Simonsator#5834), PM him (https://www.spigotmc.org/conversations/add?to=simonsator ) or write an email to him (support@simonsator.de). Please don't forget to send him the latest.log file. Also please don't write a bad review without giving him 24 hours time to fix the problem.");
            return null;
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

