/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.spigot.main;

import de.simonsator.partyandfriends.spigot.communication.sql.DriverShim;
import de.simonsator.partyandfriends.spigot.communication.sql.MySQLData;
import de.simonsator.partyandfriends.spigot.error.ErrorReporter;
import de.simonsator.partyandfriends.spigot.pafplayers.manager.PAFPlayerManagerMySQL;
import de.simonsator.partyandfriends.spigot.placeholders.placeholderapi.FriendCountPlaceHolderPlaceholderAPI;
import de.simonsator.partyandfriends.spigot.utilities.disable.Disabler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private MySQLData mySQLData;
    public static final String MARIADB_DRIVER_DOWNLOAD_URL = "https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.2.0/mariadb-java-client-3.2.0.jar";

    public void onEnable() {
        instance = this;
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        String driverURL = "jdbc:mysql://";
        if (this.getConfig().getBoolean("MySQL.UseMariaDBDriver")) {
            this.loadMariaDBConnector();
            driverURL = "jdbc:mariadb://";
        }
        this.mySQLData = new MySQLData(this.getConfig().getString("MySQL.Host"), this.getConfig().getString("MySQL.Username"), this.getConfig().getString("MySQL.Password"), this.getConfig().getInt("MySQL.Port"), this.getConfig().getString("MySQL.Database"), this.getConfig().getString("MySQL.TablePrefix"), this.getConfig().getBoolean("MySQL.UseSSL"), driverURL);
        new PAFPlayerManagerMySQL(this.mySQLData);
        Main plugin = this;
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                new FriendCountPlaceHolderPlaceholderAPI((Plugin)plugin).register();
            }
        }, 10L);
    }

    private void loadMariaDBConnector() {
        File mariadbConnector = new File(this.getDataFolder(), "MariaDB-JDBC-Connector.jar");
        if (!mariadbConnector.exists()) {
            System.out.println("Downloading MariaDB-JDBC-Connector.jar...");
            try (FileOutputStream fos = new FileOutputStream(mariadbConnector);){
                URL website = new URL(MARIADB_DRIVER_DOWNLOAD_URL);
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            catch (IOException e) {
                new ErrorReporter("\u00a7cCould not download MariaDB-JDBC-Connector.jar. Please download it from https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.2.0/mariadb-java-client-3.2.0.jar manually and put it in the Party And Friends plugin folder under the name MariaDB-JDBC-Connector.jar. Alternatively you can set \"MySQL.UseMariaDBConnector\" to false.");
                this.getConfig().set("MySQL.UseMariaDBConnector", (Object)false);
            }
        }
        if (mariadbConnector.exists()) {
            try {
                URL jarUrl = mariadbConnector.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{jarUrl}, ClassLoader.getSystemClassLoader());
                DriverManager.registerDriver(new DriverShim((Driver)Class.forName("org.mariadb.jdbc.Driver", true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | MalformedURLException | SQLException e) {
                new ErrorReporter("\u00a7cParty and Friends was not able to load the MariaDB driver from the plugin folder called MariaDB-JDBC-Connector.jar. You should try deleting the file so Party And Friends can redownload it or download it manually from https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.2.0/mariadb-java-client-3.2.0.jar and put it in the Party And Friends plugin folder under the name MariaDB-JDBC-Connector.jar. Alternatively you can set \"MySQL.UseMariaDBConnector\" to false.");
                this.getConfig().set("MySQL.UseMariaDBConnector", (Object)false);
            }
        }
    }

    public void onDisable() {
        Disabler.getInstance().disableAll();
    }

    public MySQLData getMySQLData() {
        return this.mySQLData;
    }

    public static Main getInstance() {
        return instance;
    }
}

