/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.spigot.pafplayers.mysql;

import de.simonsator.partyandfriends.spigot.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.spigot.api.pafplayers.PAFPlayerClass;
import de.simonsator.partyandfriends.spigot.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.spigot.pafplayers.manager.PAFPlayerManagerMySQL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PAFPlayerMySQL
extends PAFPlayerClass {
    final int ID;

    public PAFPlayerMySQL(int pID) {
        this.ID = pID;
    }

    @Override
    public String getName() {
        return PAFPlayerManagerMySQL.getConnection().getName(this.ID);
    }

    public int getPlayerID() {
        return this.ID;
    }

    @Override
    public List<PAFPlayer> getFriends() {
        return this.idListToPAFPlayerList(PAFPlayerManagerMySQL.getConnection().getFriends(this.ID));
    }

    @Override
    public UUID getUniqueId() {
        return PAFPlayerManagerMySQL.getConnection().getUUID(this.ID);
    }

    @Override
    public int getSettingsWorth(int pSettingsID) {
        return PAFPlayerManagerMySQL.getConnection().getSettingsWorth(this.ID, pSettingsID);
    }

    @Override
    public void setSetting(int pSettingsID, int pNewWorth) {
        PAFPlayerManagerMySQL.getConnection().setSetting(this.ID, pSettingsID, pNewWorth);
    }

    @Override
    public List<PAFPlayer> getRequests() {
        return this.idListToPAFPlayerList(PAFPlayerManagerMySQL.getConnection().getRequests(this.ID));
    }

    @Override
    public boolean isAFriendOf(PAFPlayer pPlayer) {
        return PAFPlayerManagerMySQL.getConnection().isAFriendOf(this.ID, ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    private List<PAFPlayer> idListToPAFPlayerList(List<Integer> pList) {
        ArrayList<PAFPlayer> list = new ArrayList<PAFPlayer>();
        for (int playerID : pList) {
            list.add(((PAFPlayerManagerMySQL)PAFPlayerManager.getInstance()).getPlayer(playerID));
        }
        return list;
    }

    @Override
    public PAFPlayer getPAFPlayer() {
        return this;
    }

    @Override
    public long getLastOnline() {
        return PAFPlayerManagerMySQL.getConnection().getLastOnline(this.ID).getTime();
    }

    @Override
    public boolean hasRequestFrom(PAFPlayer pPlayer) {
        return PAFPlayerManagerMySQL.getConnection().hasRequestFrom(this.ID, ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PAFPlayerMySQL) {
            return ((PAFPlayerMySQL)obj).getPlayerID() == this.ID;
        }
        return super.equals(obj);
    }
}

