/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.velocity.party.publicparty;

import de.simonsator.partyandfriends.velocity.api.PAFExtension;
import de.simonsator.partyandfriends.velocity.main.Checker;
import de.simonsator.partyandfriends.velocity.party.command.PartyCommand;
import de.simonsator.partyandfriends.velocity.party.publicparty.configuration.PublicPartyConfig;
import de.simonsator.partyandfriends.velocity.party.subcommand.BanPlayerCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.CreatePartyCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.MakePrivatePartyCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.MakePublicPartyCommand;
import de.simonsator.partyandfriends.velocity.party.subcommand.UnbanPlayerCommand;
import de.simonsator.partyandfriends.velocity.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.velocity.utilities.SubCommand;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class PublicPartyPlugin
extends PAFExtension {
    private static PublicPartyPlugin instance;
    private ConfigurationCreator config;

    public PublicPartyPlugin(Path folder) {
        super(folder);
    }

    public static PublicPartyPlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        try {
            try {
                try {
                    Class.forName("de.simonsator.partyandfriends.velocity.main.PAFPlugin");
                    Checker checker = new Checker();
                    if (checker.checkFailed()) {
                        this.sendLoadingError();
                        return;
                    }
                }
                catch (ClassNotFoundException checker) {}
            }
            catch (Exception e) {
                this.sendLoadingError();
                return;
            }
            this.config = new PublicPartyConfig(new File(this.getConfigFolder(), "config.yml"), this);
            PartyCommand.getInstance().addCommand((SubCommand)new CreatePartyCommand(this.config.getStringList("Commands.Party.SubCommands.Create.Names"), this.config.getInt("Commands.Party.SubCommands.Create.Priority"), this.config.getString("Commands.Party.SubCommands.Create.Help"), this.config.getString("Commands.Party.SubCommands.Create.Permission")));
            PartyCommand.getInstance().addCommand((SubCommand)new MakePublicPartyCommand(this.config.getStringList("Commands.Party.SubCommands.MakePublic.Names"), this.config.getInt("Commands.Party.SubCommands.MakePublic.Priority"), this.config.getString("Commands.Party.SubCommands.MakePublic.Help"), this.config.getString("Commands.Party.SubCommands.MakePublic.Permission")));
            PartyCommand.getInstance().addCommand((SubCommand)new MakePrivatePartyCommand(this.config.getStringList("Commands.Party.SubCommands.MakePrivate.Names"), this.config.getInt("Commands.Party.SubCommands.MakePrivate.Priority"), this.config.getString("Commands.Party.SubCommands.MakePrivate.Help"), this.config.getString("Commands.Party.SubCommands.MakePrivate.Permission")));
            if (!this.getConfig().getBoolean("Commands.Party.SubCommands.Ban.Disabled")) {
                PartyCommand.getInstance().addCommand((SubCommand)new BanPlayerCommand(this.config.getStringList("Commands.Party.SubCommands.Ban.Names"), this.config.getInt("Commands.Party.SubCommands.Ban.Priority"), this.config.getString("Commands.Party.SubCommands.Ban.Help"), this.config.getString("Commands.Party.SubCommands.Ban.Permission")));
            }
            if (!this.getConfig().getBoolean("Commands.Party.SubCommands.Unban.Disabled")) {
                PartyCommand.getInstance().addCommand((SubCommand)new UnbanPlayerCommand(this.config.getStringList("Commands.Party.SubCommands.Unban.Names"), this.config.getInt("Commands.Party.SubCommands.Unban.Priority"), this.config.getString("Commands.Party.SubCommands.Unban.Help"), this.config.getString("Commands.Party.SubCommands.Unban.Permission")));
            }
            this.registerAsExtension();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "Public-Party-For-PAF";
    }

    public ConfigurationCreator getConfig() {
        return this.config;
    }

    private void sendLoadingError() {
        System.out.println("\u00a7cThe extended version of Party and Friends is needed inorder to use Public Party or an illegal modified version was used.");
    }
}

