/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.subcommand;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.LeaderNeededCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.party.publicparty.PublicPartyPlugin;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;

public class UnbanPlayerCommand
extends LeaderNeededCommand {
    public UnbanPlayerCommand(List<String> pCommands, int pPriority, String pHelpText, String pPermission) {
        super(pCommands, pPriority, pHelpText, pPermission);
    }

    public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        PlayerParty party = pPlayer.getParty();
        if (!this.isInParty(pPlayer, party)) {
            return;
        }
        if (!this.isPlayerGiven(pPlayer, args)) {
            return;
        }
        PAFPlayer player = PAFPlayerManager.getInstance().getPlayer(args[0]);
        if (!player.isOnline()) {
            this.sendError(pPlayer, new TextComponent(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Join.PlayerHasNoParty")));
            return;
        }
        OnlinePAFPlayer onlinePlayer = (OnlinePAFPlayer)player;
        if (!party.isBanned((PAFPlayer)onlinePlayer)) {
            this.sendError(pPlayer, new TextComponent(this.PREFIX + PublicPartyPlugin.getInstance().getConfig().getString("Commands.Party.SubCommands.Ban.Message.IsNotBanned").replace("[PLAYER]", player.getDisplayName())));
            return;
        }
        party.setBanned((PAFPlayer)pPlayer, true);
        if (party.isInParty(onlinePlayer)) {
            party.kickPlayer(pPlayer);
        }
        party.sendMessage(this.PREFIX + PublicPartyPlugin.getInstance().getConfig().getString("Commands.Party.SubCommands.Ban.Message.WasBannedFromTheParty").replace("[PLAYER]", onlinePlayer.getDisplayName()));
    }
}

